// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/Shape/hkDisplayGeometryTypes.h>
struct hkGeometry;

/// A representation of a shape intended for visualization.
/// There are several subclasses corresponding to different shape types, but all can return
/// a hkGeometry from their getGeometry() method. The geometry should be combined with
/// the transform returned by getTransform().
/// This base class is suitable for arbitrary hkGeometry.
class HK_EXPORT_COMMON hkDisplayGeometry : public hkReferencedObject
{
    public:

        HK_DECLARE_CLASS( hkDisplayGeometry, New );

            /// Construct a display geometry with geom as its hkGeometry.
            /// This object takes ownership of geom (i.e., geom gets deleted
            /// when this object is destroyed).
        hkDisplayGeometry( hkGeometry* geom );

            /// Destructor.
        virtual ~hkDisplayGeometry();

            /// Returns a representation of this object (which should be combined with the
            /// transform obtained from getTransform). You may need to call buildGeometry
            /// to ensure that the geometry has been built.
        HK_INLINE _Ret_ const hkGeometry* getGeometry() const;
        HK_INLINE _Ret_ hkGeometry* getGeometry();

            /// Return the transform.
            
            
        HK_INLINE const hkTransform& getTransform() const;

            /// Set the transform.
            /// Not all hkpDisplayGeometry types can have a transform.
        void setTransform( const hkTransform& transform );

            /// Set the translation.
            /// Not all hkpDisplayGeometry types can have a transform.
        HK_INLINE void setTranslation( const hkVector4& translation );

            /// Ensure that the object holds a valid hkGeometry.
        virtual void buildGeometry() const;

            /// Returns the type of this geometry (see hkpDisplayGeometryType).
        HK_INLINE hkDisplayGeometryType getType() const;

            /// Set the hkGeometry member to HK_NULL so the destructor doesn't delete it.
        HK_INLINE void releaseGeometry();

            /// Returns array of points s,e,s,e,s,e - start, end ...
            /// The points should not include the transform.
        HK_INLINE void getWireframeGeometry( hkArray<hkVector4>& lines ) const
        {
            getWireframeGeometry(lines, hkContainerHeapAllocator().get(&lines) );
        }

        virtual void getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const;

    protected:

            /// Construct a hkDisplayGeometry with a null hkGeometry.
        hkDisplayGeometry( hkDisplayGeometryType type );

            /// You typically call buildGeometry to ensure this is valid.
        mutable hkGeometry* m_geometry;
        hkTransform m_transform;
        hkDisplayGeometryType m_type;
};

#include <Common/Visualize/Shape/hkDisplayGeometry.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
