// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Shape/hkDisplayGeometry.h>

hkDisplayGeometry::hkDisplayGeometry( _In_opt_ hkGeometry* geom )
:   m_geometry( geom ),
    m_type( HK_DISPLAY_ANY )
{
    m_transform.setIdentity();
}

hkDisplayGeometry::~hkDisplayGeometry()
{
    if ( m_geometry )
    {
        m_geometry->removeReference();
        m_geometry = HK_NULL;
    }
}

void hkDisplayGeometry::buildGeometry() const
{}

void hkDisplayGeometry::getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const
{
    if ( !m_geometry )
    {
        buildGeometry();
    }

#if 1
    // This effectively means the lines will be drawn twice
    // but to filter out unique edges would be pretty costly
    long v[3];
    for( int i = m_geometry->m_triangles.getSize() - 1; i >= 0; i-- )
    {
        v[0] = m_geometry->m_triangles[i].m_a;
        v[1] = m_geometry->m_triangles[i].m_b;
        v[2] = m_geometry->m_triangles[i].m_c;

        lines._pushBack( a, m_geometry->m_vertices[v[0]] );
        lines._pushBack( a, m_geometry->m_vertices[v[1]] );

        lines._pushBack( a, m_geometry->m_vertices[v[0]] );
        lines._pushBack( a, m_geometry->m_vertices[v[2]] );

        lines._pushBack( a, m_geometry->m_vertices[v[1]] );
        lines._pushBack( a, m_geometry->m_vertices[v[2]] );
    }
#else
    lines._reserve( a, lines.getSize() + m_geometry->m_triangles.getSize() * 6 );
    for( int t = 0; t < m_geometry->m_triangles.getSize(); t++ )
    {
        int* triVerts = &m_geometry->m_triangles[t].m_a;
        int j = 2;
        for (int i = 0; i < 3; j=i, ++i)
        {
            int vi = triVerts[i];
            int vj = triVerts[j];
            if (vi < vj)
            {
                lines._pushBack(a, m_geometry->m_vertices[vi]);
                lines._pushBack(a, m_geometry->m_vertices[vj]);
            }
        }
    }
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
