// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Visualize/hkVisualize.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>
#include <Common/Visualize/Shape/hkDisplayCylinder.h>
#include <Common/GeometryUtilities/Misc/hkGeometryUtils.h>

hkDisplayCylinder::hkDisplayCylinder( const hkVector4& top, const hkVector4& bottom, hkReal radius, int numSides , int numHeightSegments )
:  hkDisplayGeometry(HK_DISPLAY_CYLINDER),
   m_numSides(numSides), m_numHeightSegments(numHeightSegments)
{
    m_top = top;
    m_bottom = bottom;
    m_radius = radius;
}

/*static hkBool isOutward( hkGeometry::Triangle& t, hkArray<hkVector4>& verts )
{
    hkVector4 e0; e0.setSub( verts[t.m_b], verts[t.m_a] );
    hkVector4 e1; e1.setSub( verts[t.m_c], verts[t.m_a] );
    hkVector4 c; c.setCross( e0, e1 );
    return c.dot<3>(verts[t.m_a]) > 0;
}*/

void hkDisplayCylinder::buildGeometry() const
{
    m_geometry = new hkGeometry;
    hkGeometryUtils::appendCylinder(m_top, m_bottom, m_radius, m_numSides, m_numHeightSegments, *m_geometry);
}

void hkDisplayCylinder::getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const
{
    
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
