// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Base/Math/Vector/hkVector4Util.h>
#include <Common/Visualize/Shape/hkDisplayCone.h>

hkDisplayCone::hkDisplayCone(const hkReal coneAngle, const hkReal coneHeight,
                             const int numSegments, const hkVector4& coneAxis,
                             const hkVector4& startPos )
:   hkDisplayGeometry(HK_DISPLAY_CONE),
    m_startPos(startPos),
    m_coneAxis(coneAxis),
    m_numSegments(numSegments),
    m_coneAngle(coneAngle),
    m_coneHeight(coneHeight)
{

}

hkDisplayCone::hkDisplayCone()
:   hkDisplayGeometry(HK_DISPLAY_CONE),
    m_numSegments(0),
    m_coneAngle(0.0f),
    m_coneHeight(0.0f)
{
    m_startPos.setZero();
    m_coneAxis.setZero();
}

void hkDisplayCone::setParameters(const hkReal coneAngle,
                                  const hkReal coneHeight,
                                  const int numSegments,
                                  const hkVector4& coneAxis,
                                  const hkVector4& startPos)
{
    m_coneAngle = coneAngle;
    m_startPos = startPos;
    m_coneAxis = coneAxis;
    m_coneHeight = coneHeight;
    m_numSegments = numSegments;
}

void hkDisplayCone::generateConeVertices(hkArray<hkVector4>& conePoints) const
{
//  hkVector4 base;
//  hkVector4 previous;
//  hkVector4 current;

    // Better way -- member of class??
    conePoints.setSize(m_numSegments);

    hkVector4 perpVector;

    hkVector4Util::calculatePerpendicularVector(m_coneAxis, perpVector);
    perpVector.normalize<3>();

    hkQuaternion rotationFromNormal; rotationFromNormal.setAxisAngle(perpVector, m_coneAngle);

    hkQuaternion rotationAboutAxis; rotationAboutAxis.setAxisAngle(m_coneAxis, (HK_REAL_PI*2.0f) / m_numSegments);

    hkVector4 offsetDirection;

    offsetDirection.setRotatedDir(rotationFromNormal, m_coneAxis);

    for(int i = 0; i < m_numSegments; i++)
    {
        conePoints[i] = m_startPos;
        hkSimdReal coneH; coneH.setFromFloat(m_coneHeight);
        conePoints[i].addMul(coneH , offsetDirection);
        offsetDirection.setRotatedDir(rotationAboutAxis, offsetDirection);
    }
}

void hkDisplayCone::buildGeometry() const
{
    // build triangle hkGeometry

    m_geometry = new hkGeometry;

    generateConeVertices(m_geometry->m_vertices);

    m_geometry->m_vertices.pushBack(m_startPos);
    m_geometry->m_triangles.setSize(m_numSegments);

    int i;
    for(i = 0; i < m_numSegments - 1; i++)
    {
        m_geometry->m_triangles[i].set(m_numSegments, i + 1, i);
    }
    m_geometry->m_triangles[i].set(m_numSegments, 0, i);
}

void hkDisplayCone::getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const
{
    hkArray<hkVector4> conePoints; conePoints.reserve(256);

    generateConeVertices(conePoints);

    lines._setSize( a, 4*m_numSegments );

    int k = 0;

    for (int j = 0; j < m_numSegments; )
    {
        lines[k] = m_startPos;
        lines[++k] = conePoints[j];
        lines[++k] = conePoints[j];
        int next_point_index = (++j) % m_numSegments;
        lines[++k] = conePoints[next_point_index];
        k++;
    }
}

hkVector4 hkDisplayCone::getPosition() const
{
    return m_startPos;
}

hkVector4 hkDisplayCone::getAxis() const
{
    return m_coneAxis;
}

hkReal hkDisplayCone::getHeight() const
{
    return m_coneHeight;
}

hkReal hkDisplayCone::getAngle() const
{
    return m_coneAngle;
}

int hkDisplayCone::getNumSegments() const
{
    return m_numSegments;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
