// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>
#include <Common/GeometryUtilities/Misc/hkGeometryUtils.h>
#include <Common/Visualize/Shape/hkDisplayCapsule.h>

hkDisplayCapsule::hkDisplayCapsule( const hkVector4& top, const hkVector4& bottom, hkReal radius, int numSides , int numHeightSegments )
:  hkDisplayGeometry(HK_DISPLAY_CAPSULE),
   m_numSides(numSides), m_numHeightSegments(numHeightSegments)
{
    m_top = top;
    m_bottom = bottom;
    m_radius = radius;
}

void hkDisplayCapsule::buildGeometry() const
{
    HK_ASSERT(0x612ccd44, m_geometry==HK_NULL, "Already built");
    m_geometry = new hkGeometry();
    hkGeometryUtils::appendCapsule(m_top, m_bottom, m_radius, m_numHeightSegments, m_numSides, hkTransform::getIdentity(), *m_geometry);
}

void hkDisplayCapsule::getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const
{
    hkGeometry tempGeometry;
    hkGeometryUtils::appendCapsule(m_top, m_bottom, m_radius, m_numHeightSegments, m_numSides, hkTransform::getIdentity(), tempGeometry);

    lines._reserve(a, lines.getSize() + tempGeometry.m_triangles.getSize() * 3);
    for( int t = 0; t < tempGeometry.m_triangles.getSize(); t++ )
    {
        int* triVerts = &tempGeometry.m_triangles[t].m_a;
        for (int i = 0; i < 3; ++i)
        {
            int j = (i+1)%3;
            if (triVerts[i] < triVerts[j])
            {
                lines._pushBack(a, tempGeometry.m_vertices[triVerts[i]]);
                lines._pushBack(a, tempGeometry.m_vertices[triVerts[j]]);
            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
