// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/Shape/hkDisplayGeometry.h>

class HK_EXPORT_COMMON hkDisplayBox : public hkDisplayGeometry
{
    public:

        HK_DECLARE_CLASS( hkDisplayBox, New );

        hkDisplayBox(const hkVector4& halfExtents);
        hkDisplayBox();

        void setParameters(const hkVector4& halfExtents, const hkTransform& t);

        virtual void buildGeometry() const HK_OVERRIDE;

        virtual void getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const HK_OVERRIDE;

        inline const hkVector4& getHalfExtents() { return m_halfExtents; }

        inline const hkVector4& getHalfExtents() const { return m_halfExtents; }

    protected:

        hkVector4 m_halfExtents;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
