// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Shape/hkDisplayBox.h>

hkDisplayBox::hkDisplayBox(const hkVector4& halfExtents)
:   hkDisplayGeometry(HK_DISPLAY_BOX),
    m_halfExtents(halfExtents)
{
    m_halfExtents = halfExtents;
}

hkDisplayBox::hkDisplayBox()
:   hkDisplayGeometry(HK_DISPLAY_BOX)
{
    m_halfExtents.setZero();
}

void hkDisplayBox::setParameters(const hkVector4& halfExtents, const hkTransform& t)
{
    m_halfExtents = halfExtents;
    m_transform = t;
}

/*
8
0.000000 1.000000 1.000000
1.000000 1.000000 1.000000
1.000000 0.000000 1.000000
0.000000 0.000000 1.000000
0.000000 1.000000 0.000000
1.000000 1.000000 0.000000
1.000000 0.000000 0.000000
0.000000 0.000000 0.000000
12
3 3 2 1
3 3 1 0
3 6 7 4
3 6 4 5
3 4 7 3
3 4 3 0
3 2 6 5
3 2 5 1
3 7 6 2
3 7 2 3
3 1 5 4
3 1 4 0
*/
void hkDisplayBox::buildGeometry() const
{
    m_geometry = new hkGeometry;
    hkVector4* v = m_geometry->m_vertices.expandBy(8);

    v[0].set(-m_halfExtents(0), m_halfExtents(1), m_halfExtents(2));
    v[1].set(m_halfExtents(0), m_halfExtents(1), m_halfExtents(2));
    v[2].set(m_halfExtents(0), -m_halfExtents(1), m_halfExtents(2));
    v[3].set(-m_halfExtents(0), -m_halfExtents(1), m_halfExtents(2));
    v[4].set(-m_halfExtents(0), m_halfExtents(1), -m_halfExtents(2));
    v[5].set(m_halfExtents(0), m_halfExtents(1), -m_halfExtents(2));
    v[6].set(m_halfExtents(0), -m_halfExtents(1), -m_halfExtents(2));
    v[7].set(-m_halfExtents(0), -m_halfExtents(1), -m_halfExtents(2));

    m_geometry->m_triangles.reserve(12);
    m_geometry->m_triangles.expandOne().set(3, 2, 1);
    m_geometry->m_triangles.expandOne().set(3, 1, 0);
    m_geometry->m_triangles.expandOne().set(6, 7, 4);
    m_geometry->m_triangles.expandOne().set(6, 4, 5);
    m_geometry->m_triangles.expandOne().set(4, 7, 3);
    m_geometry->m_triangles.expandOne().set(4, 3, 0);
    m_geometry->m_triangles.expandOne().set(2, 6, 5);
    m_geometry->m_triangles.expandOne().set(2, 5, 1);
    m_geometry->m_triangles.expandOne().set(7, 6, 2);
    m_geometry->m_triangles.expandOne().set(7, 2, 3);
    m_geometry->m_triangles.expandOne().set(1, 5, 4);
    m_geometry->m_triangles.expandOne().set(1, 4, 0);

    /*int bytessaved =*/
}

void hkDisplayBox::getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const
{
    lines._setSize( a, 24 );

    hkVector4 points[8];

    // points
    {
        for (int i = 0; i < 8; i++)
        {
            hkVector4 v = m_halfExtents;
            if ( i & 1 )    v(0) *= -1.0f;
            if ( i & 2 )    v(1) *= -1.0f;
            if ( i & 4 )    v(2) *= -1.0f;
            points[i] = v;
        }
    }

    // edges
    {
        int k = 0;
        for (int i = 0; i < 8; i++)
        {
            for ( int bit = 1; bit < 8; bit <<= 1 )
            {
                int j = i ^ bit;

                if ( i < j )
                {
                    lines[k++] = points[i];
                    lines[k++] = points[j];
                }
            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
