// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Shape/hkDisplayAABB.h>

hkDisplayAABB::hkDisplayAABB(const hkAabb& aabb)
:   hkDisplayGeometry(HK_DISPLAY_AABB),
    m_minExtent(aabb.m_min),
    m_maxExtent(aabb.m_max)
{}

hkDisplayAABB::hkDisplayAABB(const hkVector4& min, const hkVector4& max)
:   hkDisplayGeometry(HK_DISPLAY_AABB),
    m_minExtent(min),
    m_maxExtent(max)
{}

hkDisplayAABB::hkDisplayAABB()
:   hkDisplayGeometry(HK_DISPLAY_AABB)
{
    m_minExtent.setZero();
    m_maxExtent.setZero();
}

void hkDisplayAABB::setExtents(const hkVector4& min, const hkVector4& max)
{
    m_minExtent = min;
    m_maxExtent = max;
}

void hkDisplayAABB::buildGeometry() const
{
    // build triangle hkGeometry
    m_geometry = new hkGeometry;
    m_geometry->m_vertices.setSize(8);
    m_geometry->m_vertices[0].set(m_minExtent(0),m_minExtent(1),m_minExtent(2));
    m_geometry->m_vertices[1].set(m_minExtent(0),m_minExtent(1),m_maxExtent(2));
    m_geometry->m_vertices[2].set(m_maxExtent(0),m_minExtent(1),m_maxExtent(2));
    m_geometry->m_vertices[3].set(m_maxExtent(0),m_minExtent(1),m_minExtent(2));
    m_geometry->m_vertices[4].set(m_minExtent(0),m_maxExtent(1),m_minExtent(2));
    m_geometry->m_vertices[5].set(m_minExtent(0),m_maxExtent(1),m_maxExtent(2));
    m_geometry->m_vertices[6].set(m_maxExtent(0),m_maxExtent(1),m_maxExtent(2));
    m_geometry->m_vertices[7].set(m_maxExtent(0),m_maxExtent(1),m_minExtent(2));

    // tris are CCW order -  is this right?
    m_geometry->m_triangles.reserve(12);
    m_geometry->m_triangles.expandByUnchecked(1)->set(0,3,1);
    m_geometry->m_triangles.expandByUnchecked(1)->set(1,3,2);
    m_geometry->m_triangles.expandByUnchecked(1)->set(2,6,5);
    m_geometry->m_triangles.expandByUnchecked(1)->set(5,1,2);
    m_geometry->m_triangles.expandByUnchecked(1)->set(5,6,4);
    m_geometry->m_triangles.expandByUnchecked(1)->set(4,6,7);
    m_geometry->m_triangles.expandByUnchecked(1)->set(7,3,0);
    m_geometry->m_triangles.expandByUnchecked(1)->set(0,4,7);
    m_geometry->m_triangles.expandByUnchecked(1)->set(0,1,4);
    m_geometry->m_triangles.expandByUnchecked(1)->set(4,1,5);
    m_geometry->m_triangles.expandByUnchecked(1)->set(2,3,6);
    m_geometry->m_triangles.expandByUnchecked(1)->set(6,3,7);

    /*int bytessaved = */
}

const hkVector4& hkDisplayAABB::getMinExtent() const
{
    return m_minExtent;
}

const hkVector4& hkDisplayAABB::getMaxExtent() const
{
    return m_maxExtent;
}

void hkDisplayAABB::getWireframeGeometry( hkArrayBase<hkVector4>& lines, hkMemoryAllocator& a ) const
{
    lines._setSize( a, 24 );
    hkAabb aabb;
    aabb.m_min = m_minExtent;
    aabb.m_max = m_maxExtent;
    int d = 0;
    for (int i =0; i < 7; i++)
    {
        for (int j=1; j < 8; j+=j)
        {
            if ( (i^j) > i )
            {
                aabb.getVertex( i+0, lines[d++]);
                aabb.getVertex( i^j, lines[d++]);
            }
}

    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
