// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

hkBool32 hkVdbReflect::Var::isValid() const
{
    return hkVdbSerialize::isTypeValid( getType() );
}

int hkVdbReflect::Var::numProperties() const
{
    int count = 0;
    const hkReflect::RecordType* recordType = getType()->asRecord();
    while ( recordType )
    {
        hkArrayView<const hkReflect::FieldDecl> fieldView = recordType->getDataFields();
        for ( hkArrayView<const hkReflect::FieldDecl>::const_iterator fieldIt = fieldView.begin();
            fieldIt != fieldView.end();
            fieldIt++ )
        {
            count += hkVdbSerialize::isSubTypeValid( fieldIt->getType() );
        }
        recordType = recordType->getParentRecord();
    }
    return count;
}

hkBool32 hkVdbReflect::Var::hasProperty( const char* name ) const
{
    if ( hkReflect::FieldDecl field = getType()->findField( name, true ) )
    {
        if ( hkReflect::DataFieldDecl dataField = field.asDataField() )
        {
            return hkVdbSerialize::isSubTypeValid( dataField.getType() );
        }
    }
    return false;
}

hkVdbReflect::Var hkVdbReflect::Var::findProperty( const char* name ) const
{
    if ( hkReflect::FieldDecl field = getType()->findField( name, true ) )
    {
        if ( hkReflect::DataFieldDecl dataField = field.asDataField() )
        {
            return hkVdbSerialize::isSubTypeValid( dataField.getType() ) ? hkReflect::Var( ( ( hkInt8* ) getAddress() ) + dataField.getOffset(), dataField.getType() ) : hkReflect::Var();
        }
    }
    return hkReflect::Var();
}

hkVdbReflect::Var::_Iterator::_Iterator( hkReflect::Var var ) :
    m_var( var ),
    m_recordType( HK_NULL ),
    m_fieldIt( HK_NULL ),
    m_fieldItEnd( HK_NULL )
{
    if ( const hkReflect::Type* objectType = m_var.getType() )
    {
        m_recordType = objectType->asRecord();
        // initialize to our first valid prop
        operator++();
    }
}

const hkVdbReflect::Var::_Iterator& hkVdbReflect::Var::_Iterator::operator++()
{
    m_fieldIt++;
    while ( m_recordType )
    {
        // Skip non-valid fields
        while ( m_fieldIt < m_fieldItEnd )
        {
            
            
            if ( hkVdbSerialize::isSubTypeValid( m_fieldIt->getType() ))
            {
                break;
            }
            m_fieldIt++;
        }

        // Check for end of this record's fields
        if ( m_fieldIt >= m_fieldItEnd )
        {
            // First time through, use the initial record type, otherwise get our parent
            m_recordType = ( !m_fieldItEnd ) ? m_recordType : m_recordType->getParentRecord();

            // Get our iterator over the fields
            if ( m_recordType )
            {
                hkArrayView<const hkReflect::FieldDecl> fieldView = m_recordType->getDataFields();
                m_fieldIt = fieldView.begin();
                m_fieldItEnd = fieldView.end();
                // Loop back to top and find first valid field
            }
            else
            {
                m_fieldIt = HK_NULL;
                m_fieldItEnd = HK_NULL;
                // We will exit our while loop because !m_recordType
            }
        }
        else
        {
            break;
        }
    }
    return *this;
}

const hkVdbReflect::Var::_Iterator hkVdbReflect::Var::_Iterator::operator++( int )
{
    hkVdbReflect::Var::_Iterator temp = *this;
    ++*this;
    return temp;
}

const hkVdbReflect::Var::_Iterator hkVdbReflect::Var::_Iterator::operator+( int i ) const
{
    hkVdbReflect::Var::iterator it = *this;
    while ( ( i > 0 ) && ( m_fieldIt != m_fieldItEnd ) )
    {
        ++it;
        --i;
    }
    return it;
}

const hkVdbReflect::Var::_Iterator& hkVdbReflect::Var::_Iterator::operator+=( int i )
{
    *this = operator+( i );
    return *this;
}

bool hkVdbReflect::Var::_Iterator::operator==( const _Iterator& iter ) const
{
    return ( m_recordType == iter.m_recordType ) && ( m_fieldIt == iter.m_fieldIt );
}

bool hkVdbReflect::Var::_Iterator::operator<( const _Iterator& iter ) const
{
    return
        ( m_recordType && !iter.m_recordType ) ||
        ( ( m_recordType == iter.m_recordType ) && ( m_fieldIt < iter.m_fieldIt ) );
}

bool hkVdbReflect::Var::_Iterator::operator>( const _Iterator& iter ) const
{
    return
        ( !m_recordType && iter.m_recordType ) ||
        ( ( m_recordType == iter.m_recordType ) && ( m_fieldIt > iter.m_fieldIt ) );
}

hkVdbReflect::Var hkVdbReflect::Var::_Iterator::operator*()
{
    if ( m_recordType )
    {
        const hkReflect::Type* fieldType = m_fieldIt->getType();
        HK_ASSERT( 0x22441170, hkVdbSerialize::isSubTypeValid( fieldType ), "Iterated to an invalid next item" );
        return hkReflect::Var( ( ( hkInt8* ) m_var.getAddress() ) + m_fieldIt->getOffset(), fieldType );
    }
    else
    {
        return hkReflect::Var();
    }
}

const char* hkVdbReflect::Var::_Iterator::name() const
{
    if ( m_recordType )
    {
        return m_fieldIt->getName();
    }
    else
    {
        return HK_NULL;
    }
}

hkVdbReflect::Var::iterator hkVdbReflect::Var::begin()
{
    return _Iterator( *this );
}

hkVdbReflect::Var::iterator hkVdbReflect::Var::end()
{
    if ( this->getType()->asRecord() )
    {
        return _Iterator( hkReflect::Var() );
    }
    else
    {
        return _Iterator( *this );
    }
}

hkVdbReflect::Var::const_iterator hkVdbReflect::Var::begin() const
{
    return const_cast< hkVdbReflect::Var* >( this )->begin();
}

hkVdbReflect::Var::const_iterator hkVdbReflect::Var::end() const
{
    return const_cast< hkVdbReflect::Var* >( this )->end();
}

template<typename KeyType, typename IdType, bool RefCount>
IdType hkObjectIdRegistry<KeyType, IdType, RefCount>::getOrCreateIdInternal(
    const KeyType& key,
    hkBool32& wasIdCreatedOut,
    hkUint32 initRefCount )
{
    IdPlusRefCount nextReffedId;
    nextReffedId.m_id = ( m_idPool.getSize() ) ? m_idPool.back() : m_nextId;
    typename hkHashMap<KeyType, IdPlusRefCount>::Iterator iter = m_keyToIdMap.findOrInsertKey( key, nextReffedId );
    IdPlusRefCount& reffedId = m_keyToIdMap.getValue( iter );
    wasIdCreatedOut = ( reffedId.m_id == nextReffedId.m_id );
    if ( wasIdCreatedOut )
    {
        if ( m_idPool.getSize() )
        {
            m_idPool.popBack();
        }
        else
        {
            m_nextId++;
        }

        if ( RefCount )
        {
            reffedId.m_refCount = initRefCount;
        }
    }
    else if ( RefCount )
    {
        reffedId.m_refCount++;
    }
    return reffedId.m_id;
}

template<typename KeyType, typename IdType, bool RefCount>
IdType hkObjectIdRegistry<KeyType, IdType, RefCount>::freeId(
    const KeyType& key,
    hkBool32& wasIdFreedOut )
{
    typename hkHashMap<KeyType, IdPlusRefCount>::Iterator iter = m_keyToIdMap.findKey( key );
    if ( m_keyToIdMap.isValid( iter ) )
    {
        IdPlusRefCount& reffedId = m_keyToIdMap.getValue( iter );
        if ( RefCount )
        {
            reffedId.m_refCount--;
        }
        if ( !RefCount || ( reffedId.m_refCount == 0 ) )
        {
            IdType id = reffedId.m_id;
            m_idPool.pushBack( id );
            m_keyToIdMap.remove( iter );
            wasIdFreedOut = true;
            return id;
        }
        wasIdFreedOut = false;
        return reffedId.m_id;
    }
    wasIdFreedOut = false;
    return 0;
}

template<typename KeyType, typename IdType>
template<typename Functor>
void hkTransientObjectIdRegistry<KeyType, IdType>::step( Functor freedIdsFunctor )
{
    m_step++;

    hkLocalArray<hkTuple<KeyType, IdType>> pairsToRemove( m_keyToIdMap.getSize() );
    for ( auto iter = m_keyToIdMap.getIterator();
        m_keyToIdMap.isValid( iter );
        iter = m_keyToIdMap.getNext( iter ) )
    {
        auto& reffedId = m_keyToIdMap.getValue( iter );
        if ( reffedId.m_refCount < m_step )
        {
            // Check that we didn't miss a removal somehow.
            HK_ASSERT_NO_MSG( 0x22441406, reffedId.m_refCount == ( m_step - 1 ) );
            const KeyType& key = m_keyToIdMap.getKey( iter );
            const IdType& id = reffedId.m_id;
            pairsToRemove.pushBack( hkTupleT::make( key, id ) );
        }
    }

    for ( int i = 0; i < pairsToRemove.getSize(); i++ )
    {
        hkTuple<KeyType, IdType>& pair = pairsToRemove[i];
        m_idPool.pushBack( pair.m_1 );
        m_keyToIdMap.remove( pair.m_0 );
        freedIdsFunctor( pair.m_1 );
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
