// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Reader/Memory/hkMemoryStreamReader.h>
#include <Common/Base/System/Io/IArchive/hkIArchive.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>

class hkTriangleIndices;
class hkDisplayGeometry;

/// This utility class extends the hkIArchive to provide a endian
/// safe stream interface for deserializing all of the basic data
/// types associated with the visual debugger.
class HK_EXPORT_COMMON hkVdbIStream : public hkIArchive
{
public:
    HK_DECLARE_CLASS( hkVdbIStream, New );

    /// Constructs a new hkVdbIStream with the specified hkStreamReader.
    /// Note: hkVdbIStream is not safe to use with non-blocking streams.
    hkVdbIStream( _Inout_ hkStreamReader* sb, bool byteswap = HK_ENDIAN_BIG );

    /// Uses the hkFileSystem to get an hkStreamReader for filename.
    hkVdbIStream( _In_z_ const char* filename, bool byteswap = HK_ENDIAN_BIG );

    /// Uses the 'mem' inplace. 'mem' should be valid for the lifetime of this object.
    hkVdbIStream( _In_bytecount_( memSize ) const void* mem, int memSize, bool byteswap = HK_ENDIAN_BIG );

    /// Deserialize an hkVector4.
    void readQuadVector4( hkVector4& v );

    /// Deserialize an hkTransform.
    void readTransform( hkTransform& t );

    /// Deserialize an hkMatrix4.
    void readMatrix( hkMatrix4& m );

    /// Deserialize an hkGeometry::Triangle.
    void readTriangle( hkGeometry::Triangle& ti );

    /// Deserialize an hkGeometry.
    void readGeometry( hkGeometry& g );

    /// Deserialize an hkArray of hkVector4s
    void readVectorArray( hkArray<hkVector4>& v );

    /// Deserialize an hkDisplayGeometry.
    void readDisplayGeometry( _Outref_result_maybenull_ hkDisplayGeometry*& dg );

    /// Deserialize an aabb.
    void readAabb( hkAabb& aabb );
};

/// An hkVdbIStream meant to be used locally (on the stack).
/// It's optimized for this case to reduce ctor/dtor overhead.
struct HK_EXPORT_COMMON hkVdbLocalIStream : public hkVdbIStream
{
    HK_DECLARE_CLASS( hkVdbLocalIStream, New );
    hkVdbLocalIStream( const void* mem, int memSize ) :
        hkVdbIStream( ( hkStreamReader* ) HK_NULL ),
        m_inplaceReader( mem, memSize, hkMemoryStreamReader::MEMORY_INPLACE )
    {
        setStreamReader( &m_inplaceReader );
        m_inplaceReader.setMemorySizeAndFlags( 0 );
    }
    int tell() const { return m_inplaceReader.tell(); }
protected:
    hkMemoryStreamReader m_inplaceReader;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
