// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Serialize/Format/Tagfile/hkTagfileReadFormat.h>

/// A TagfileReadFormat which can have it's internal state to persist across
/// to another hkPersistableReadFormat.
/// This allows for a read format to "pick up where another left off".
class HK_EXPORT_COMMON hkPersistableReadFormat : public hkSerialize::TagfileReadFormat
{
public:
    HK_DECLARE_CLASS( hkPersistableReadFormat, New );
    hkPersistableReadFormat();

    //
    // hkSerialize::ReadFormat interface
    //

    virtual hkViewPtr<hkSerialize::Bundle> read( hkIo::ReadBuffer& rb ) HK_OVERRIDE;
    virtual hkViewPtr<hkSerialize::Bundle> view( const void* buf, hkUlong bufLen, hkUlong* usedOut ) HK_OVERRIDE;
    virtual hkViewPtr<hkSerialize::Bundle> inplace( const void* buf, hkUlong bufLen, hkUlong* usedOut, const hkReflect::TypeReg* typeReg ) HK_OVERRIDE;

    /// Return the internal data of the read format which can later be unpersisted.
    const hkArrayBase<hkInt8>& persist() const { HK_ASSERT_DEV( 0x22441008, !m_invariantState, "Cannot re-persist" ); return m_persistentState; };

    /// Unpersist previous data (see persist).
    void unpersist( const hkArrayBase<hkInt8>& persistentState, hkBool32 repersistable = false );

protected:

    void updatePersistentState(hkIo::ReadBuffer& rb );

    hkBool32 m_invariantState;
    hkArray<hkInt8> m_persistentState;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
