// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Serialize/hkPersistableReadFormat.h>

#include <Common/Base/System/Io/Structured/hkStructuredStream.h>
#include <Common/Base/Serialize/Format/Tagfile/Detail/hkTagfileDetail.h>

hkPersistableReadFormat::hkPersistableReadFormat() :
    m_invariantState( false )
{}

hkViewPtr<hkSerialize::Bundle> hkPersistableReadFormat::read( hkIo::ReadBuffer& rb )
{
    updatePersistentState( rb );
    return hkSerialize::TagfileReadFormat::read( rb );
}

hkViewPtr<hkSerialize::Bundle> hkPersistableReadFormat::view( const void* buf, hkUlong bufLen, hkUlong* usedOut )
{
    hkIo::Detail::ReadBufferAdapter adapter( buf, bufLen );
    hkIo::ReadBuffer buffer( adapter );
    updatePersistentState( buffer );
    return hkSerialize::TagfileReadFormat::view( buf, bufLen, usedOut );
}

hkViewPtr<hkSerialize::Bundle> hkPersistableReadFormat::inplace( const void* buf, hkUlong bufLen, hkUlong* usedOut, const hkReflect::TypeReg* typeReg )
{
    hkIo::Detail::ReadBufferAdapter adapter( buf, bufLen );
    hkIo::ReadBuffer buffer( adapter );
    updatePersistentState( buffer );
    return hkSerialize::TagfileReadFormat::inplace( buf, bufLen, usedOut, typeReg );
}

void hkPersistableReadFormat::unpersist( const hkArrayBase<hkInt8>& persistentState, hkBool32 repersistable )
{
    

    // Save framework doesn't have sync for hkInt8 array, only char
    // COM-3780
    const hkArray<char>* byteArray = reinterpret_cast< const hkArray<char>* >( &persistentState );

    // Store locally if needed
    if ( repersistable )
    {
        m_persistentState.setSize( persistentState.getSize() );
        hkString::memCpy( m_persistentState.begin(), persistentState.begin(), persistentState.getSize() );
        byteArray = reinterpret_cast< const hkArray<char>* >( &m_persistentState );
    }
    else
    {
        m_invariantState = true;
    }

    hkUlong offset = 0;
    while ( offset < hkUlong( byteArray->getSize() ) )
    {
        hkUlong used;
        
        hkSerialize::TagfileReadFormat::view( byteArray->begin() + offset, byteArray->getSize(), &used );
        offset += used;

        // Avoid inf loops for corrupt data.
        if ( used == 0 )
        {
            break;
        }
    }
}

void hkPersistableReadFormat::updatePersistentState(hkIo::ReadBuffer& rb )
{
    using namespace hkSerialize;

    if ( m_invariantState )
    {
        // No-op, our persistent state is invariant.
        return;
    }

#if 0
    // Unpersist assert/crash check
    hkUlong _used;
    hkPersistableReadFormat _format;
    _format.unpersist( m_persistentState, true );
    _format.hkSerialize::TagfileReadFormat::view( rb.peekAt<void>(), rb.getPrefetchedSize(), &_used );
#endif

    // Walk over the tagfile data and save *only* type information to our persistent state.
    {
        // Save framework doesn't have sync for hkInt8 array, only char
        // COM-3780
        hkArray<char>& byteArray = reinterpret_cast< hkArray<char>& >( m_persistentState );
        hkIo::WriteBuffer writeBuf(&byteArray);
        HffWriter writer( writeBuf );

        // Enter the root scope
        hkLong prefetchedSize = rb.prefetchAll();
        HffMemoryReader reader( rb.peekAt<void>(), prefetchedSize );
        Ident ident = reader.enter();
        if ( ident && ( ident != HffBase::IDENT_IO_ERROR ) )
        {
            // Open root branch
            writer.openBranch( Detail::TagfileRoot::TAGFILE );

            // Process nested scopes
            HK_ON_DEBUG( bool processedTypeSection = false; )
            while ( true )
            {
                ident = reader.enter();

                // Check for break condition
                if ( ( ident == HffBase::IDENT_NONE ) || ( ident == HffBase::IDENT_IO_ERROR ) )
                {
                    break;
                }

                
                
                
                if ( ident == Detail::TagfileSection::TYPES )
                {
                    HK_ASSERT( 0x22441378, !processedTypeSection, "Tagile format has changed, it contains more than one type section" );

                    // Write the types section if it has data
                    if ( reader.sizeContent() )
                    {
                        hkIo::ReadBufferView view = reader.view();
                        writer.writeLeaf( Detail::TagfileSection::TYPES, view.begin(), hkInt32( view.remaining() ) );
                    }

                    // Shouldn't be any more type sections
#ifdef HK_DEBUG
                    processedTypeSection = true;
                    reader.leave();
#else
                    break;
#endif
                }
                else
                {
                    reader.skipContent();
                    reader.leave();
                }
            }

            // Close the root branch
            writer.close();
        }
        reader.abort();
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
