// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Monitor/MonitorStreamAnalyzer/hkMonitorStreamParser.h>

#include <Common/Visualize/hkProcess.h>
#include <Common/Visualize/hkVisualDebuggerCmdType.h>

class hkDisplayHandler;
class hkProcessContext;
class hkCommonProcessContext;

namespace hkSerialize
{
    class WriteFormat;
}

/// Process (viewer) for sending statistics to vdb client.
/// Most notably the hkMonitorStreams (timer/perf data).
class HK_EXPORT_COMMON hkStatisticsProcess : public hkReferencedObject, public hkProcess
{
public:
    HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_VDB );

    /// Creates an hkStatisticsProcess.
    static _Ret_notnull_ hkProcess* HK_CALL create( const hkArray<hkProcessContext*>& contexts );

    /// Registers the hkStatisticsProcess with the hkProcessFactory.
    static void HK_CALL registerProcess();

    /// Get the name used for all process instances of this class.
    static inline _Ret_z_ const char* HK_CALL getName() { return "Statistics"; }

    //
    // hkProcess interface
    //
    virtual int getProcessTag() const HK_OVERRIDE { return s_tag; }
    virtual void step( hkReal frameTimeInMs ) HK_OVERRIDE;

protected:

    hkStatisticsProcess( const hkArray<hkProcessContext*>& contexts );
    virtual ~hkStatisticsProcess();
    void sendMemoryStats();
    void writeOutStatsBuffers( hkArrayView<hkTimerData> timers, hkVdbCmdType::Enum command );

protected:

    hkCommonProcessContext* m_context;
    hkRefPtr<hkSerialize::WriteFormat> m_format;

    hkMonitorStreamStringMap m_stringMap;
    hkMonitorStreamTypeMap m_typeMap;

    hkArray<char> m_stringMapBuffer;
    hkArray<char> m_typeMapBuffer;

    hkUint32 m_sessionId;

    static int s_tag;
    static hkUint32 s_nextSessionId;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
