// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Process/hkRemoteObjectProcess.h>
#include <Common/Visualize/hkProcessFactory.h>
#include <Common/Base/Serialize/hkSerialize.h>
#include <Common/Visualize/Serialize/hkVdbIStream.h>
#include <Common/Visualize/Serialize/hkVdbOStream.h>
#include <Common/Visualize/hkVisualDebuggerCmdType.h>

int hkRemoteObjectProcess::s_tag = 0;

void hkRemoteObjectClientSideListener::sendObject( _Inout_ hkReferencedObject* object )
{
    if( m_sendFunc != HK_NULL )
    {
        m_sendFunc(object);
    }
}

hkRemoteObjectProcess::hkRemoteObjectProcess()
{
}

hkRemoteObjectProcess::~hkRemoteObjectProcess()
{
    for(hkHashMap<int, hkSerialize::Load*>::Iterator iter = m_deserializers.getIterator();
        m_deserializers.isValid(iter); iter = m_deserializers.getNext(iter))
    {
        delete m_deserializers.getValue(iter);
    }
}

void hkRemoteObjectProcess::init()
{
}

void hkRemoteObjectProcess::addListener( _In_ hkRemoteObjectServerSideListener* listener )
{
    m_listeners.pushBack(listener);
}

void hkRemoteObjectProcess::removeListener(_In_ hkRemoteObjectServerSideListener* listener )
{
    hkInt32 index = m_listeners.indexOf(listener);
    if( index != -1 )
    {
        m_listeners.removeAt(index);
    }
}

static void _writeLiveObjectData( hkVdbOStream* stream, int tag, const hkArray<char>::Temp& buf )
{
    stream->write8u( hkVdbCmdType::DEPRECATED_LIVE_OBJECT );
    stream->write32( tag );
    stream->write32( buf.getSize() );
    stream->writeRaw( buf.begin(), buf.getSize() );
}

void hkRemoteObjectProcess::sendObject( hkVdbOStream* stream, hkSerialize::Save& serializer, const hkReflect::Var& object, int tag )
{
    if( stream != HK_NULL )
    {
        hkArray<char>::Temp buf;
        serializer.contentsVar(object, &buf);
        const int packetSize = 1 + 4 + 4 + buf.getSize();
        stream->write32u(packetSize);
        _writeLiveObjectData(stream, tag, buf);
    }
}

void hkRemoteObjectProcess::writeObjectDataOnly( hkVdbOStream* stream, hkSerialize::Save& serializer, const hkReflect::Var& object, int tag )
{
    if( stream != HK_NULL )
    {
        hkArray<char>::Temp buf;
        serializer.contentsVar(object, &buf);
        //Client->Server doesn't contain packet sizes
        //const int packetSize = 1 + 4 + 4 + buf.getSize();
        //stream->write32u(packetSize);
        _writeLiveObjectData( stream, tag, buf );
    }
}

static hkUint8 _remoteObject_cmds[] = { hkVdbCmdType::DEPRECATED_LIVE_OBJECT };

void hkRemoteObjectProcess::getConsumableCommands(_Outref_result_bytebuffer_maybenull_(numCommands) hkUint8*& commands, _Out_ int& numCommands )
{
    commands = _remoteObject_cmds;
    numCommands = 1;
}

void hkRemoteObjectProcess::consumeCommand( hkUint8 command )
{
    if(command == hkVdbCmdType::DEPRECATED_LIVE_OBJECT)
    {
        int tag = m_inStream->read32();
        hkSerialize::Load* loader = m_deserializers.getWithDefault(tag, HK_NULL);
        if(!loader)
        {
            loader = new hkSerialize::Load;
            m_deserializers.insert(tag, loader);
        }

        hkArray<char>::Temp buffer;
        int dataSize = m_inStream->read32();
        buffer.setSize(dataSize);
        m_inStream->readRaw(buffer.begin(), dataSize);

        if ( hkReferencedObject* refObj = loader->toObject<hkReferencedObject>( buffer.begin(), buffer.getSize() ) )
        {
            for( int i = 0; i < m_listeners.getSize(); i++ )
            {
                m_listeners[i]->receiveObjectCallback( refObj );
            }
        }
        else
        {
            
            HK_WARN_ALWAYS( 0x6345fed, "Could not load object from network for unknown reason" );
        }
    }
}

_Ret_notnull_ hkProcess* HK_CALL hkRemoteObjectProcess::create(const hkArray<hkProcessContext*>& contexts)
{
    return new hkRemoteObjectProcess();
}

void HK_CALL hkRemoteObjectProcess::registerProcess()
{
    s_tag = hkProcessFactory::getInstance().registerProcess( getName(), create );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
