// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Process/hkMemorySnapshotProcess.h>
#include <Common/Visualize/hkProcessFactory.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>
#include <Common/Base/Memory/System/hkMemorySystem.h>
#include <Common/Base/Memory/Tracker/hkMemoryTracker.h>
#include <Common/Base/Memory/Tracker/hkMemoryTrackerReportUtil.h>
#include <Common/Base/System/Io/Writer/Array/hkArrayStreamWriter.h>
#include <Common/Visualize/hkProcessHandler.h>
#include <Common/Visualize/hkServerFileHandler.h>
#include <Common/Base/Memory/System/Util/hkMemorySnapshot.h>
#include <Common/Base/Memory/Tracker/hkMemoryTrackerSnapshot.h>

int hkMemorySnapshotProcess::s_tag = 0;

void HK_CALL hkMemorySnapshotProcess::registerProcess()
{
    s_tag = hkProcessFactory::getInstance().registerProcess( getName(), create );
}

_Ret_notnull_ hkProcess* HK_CALL hkMemorySnapshotProcess::create( const hkArray<hkProcessContext*>& contexts )
{
    return new hkMemorySnapshotProcess( contexts );
}

hkMemorySnapshotProcess::hkMemorySnapshotProcess( const hkArray<hkProcessContext*>& contexts )
{}

void hkMemorySnapshotProcess::step( hkReal frameTimeInMs )
{
    // step once, send the HKX file in full (in native console format, so less likely to hit any serialization issues)
    if (m_outStream)
    {

        hkMallocAllocator allocator;
        hkMemorySnapshot memorySnapshot(&allocator);
        hkMemoryTrackerSnapshot trackerSnapshot(&allocator);
        hkMemoryTrackerReportUtil::takeSnapshots(hkMemoryTracker::getInstancePtr(), memorySnapshot, trackerSnapshot);

        hkArray<char> storage;
        storage.reserve( 100 * 1024 ); // 100KB
        hkArrayStreamWriter sw( &storage, hkArrayStreamWriter::ARRAY_BORROW );
        hkOstream os( &sw );
        hkMemoryTrackerReportUtil::generateReport( memorySnapshot, trackerSnapshot, os );

        const char* ext = "hkmem";
        m_fileHandler->sendFileData(
            storage.begin(),
            storage.getSize(),
            "Havok Memory Snapshot",
            hkArrayViewT::fromSingleObject( ext ),
            s_tag );
    }

    // Now we have done the work, we can turn ourselves off.
    if (m_processHandler)
    {
        m_processHandler->deleteProcess( s_tag );

        //as our name has a '*' in it, the VDB clients will expect us to have deleted ourselves, so should be fine.
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
