// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Visualize/hkProcess.h>
#include <Common/Visualize/hkDebugDisplayHandler.h>

class hkProcessContext;

/// Process (viewer) for enabling debug display drawing to be sent to vdb client.
class HK_EXPORT_COMMON hkDebugDisplayProcess : public hkProcess
{
    public:
        HK_DECLARE_CLASS( hkDebugDisplayProcess, New );
        hkDebugDisplayProcess();
        virtual ~hkDebugDisplayProcess();

        /// Creates an hkDebugDisplayProcess.
        static hkProcess* HK_CALL create( const hkArray<hkProcessContext*>& contexts );

        /// Registers the hkDebugDisplayProcess with the hkProcessFactory.
        static void HK_CALL registerProcess();

        /// Get the tag for all process instances of this class.
        static int getProcessTagStatic() { return s_tag; }

        /// Get the name used for all process instances of this class.
        static inline const char* HK_CALL getName() { return "Debug Display"; }

        //
        // hkProcess interface
        //

        virtual int getProcessTag() const HK_OVERRIDE { return s_tag; }
        virtual void init() HK_OVERRIDE;

    protected:

        static int s_tag;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
