// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/CommandStream/hkCommandStream.h>
#include <Common/Base/Types/Color/hkColor.h>



class hkDebugCommand: public hkCommand
{
public:
    enum
    {
        CMD_DEBUG_LINE,
    };

    hkDebugCommand( hkUint16 subType, int sizeInBytes ): hkCommand(TYPE_DEBUG_DISPLAY, subType, sizeInBytes )
    {
    }
};


/// A list of default command functions to be used in the header of a command (non virtual).
#define HK_DEFAULT_DEBUG_COMMAND_FUNCTIONS \
    void printCommand  (hkOstream& stream) const

struct hkEmptyDebugCommand: public hkDebugCommand
{
    hkEmptyDebugCommand( ): hkDebugCommand( CMD_DEBUG_LINE, sizeof(*this)){ ; }
    HK_INLINE void printCommand  (hkOstream& stream) const {}
    HK_INLINE void checkIsEmptyCommand() const {}   // This allows the compiler to check that all commands are dispatched
};



#define HK_DECLARE_DEBUG_COMMAND_DISCRIMINATOR( TYPE, ID)   \
    template <     >    struct hkDebugCommandTypeDiscriminator<hkDebugCommand::ID>{ typedef TYPE CommandType; }

template <int X>    struct hkDebugCommandTypeDiscriminator           { typedef hkEmptyDebugCommand CommandType; };


struct hkDebugLineCommand: public hkDebugCommand
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_PHYSICS, hkDebugLineCommand);
    hkDebugLineCommand( hkVector4Parameter start, hkVector4Parameter end, hkColor::Argb color ):
        hkDebugCommand( CMD_DEBUG_LINE, sizeof(*this)){ m_start = start; m_end = end; m_color = color; }

    hkDebugLineCommand() : hkDebugCommand( CMD_DEBUG_LINE, sizeof(*this) ) {}

    HK_DEFAULT_DEBUG_COMMAND_FUNCTIONS;

    hkColor::Argb m_color;
    hkVector4 m_start;
    hkVector4 m_end;
};
HK_DECLARE_DEBUG_COMMAND_DISCRIMINATOR( hkDebugLineCommand, CMD_DEBUG_LINE );


class HK_EXPORT_COMMON hkDebugCommandProcessor: public hkSecondaryCommandDispatcher
{
    public:
        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE);

        hkDebugCommandProcessor(){}

        /// dispatch commands
        virtual void exec( const hkCommand& command );

        virtual void print( const hkCommand& command, hkOstream& stream ) const ;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
