// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Visualize/hkProcessContext.h>

#define HK_SCENE_DATA_CONTEXT_TYPE_STRING "SceneData"

class hkxScene;

    /// Callback interface for hkxSceneDataContext.
class HK_EXPORT_COMMON hkxSceneDataContextListener
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_TOOLS, hkxSceneDataContextListener);

            /// Empty destructor
        virtual ~hkxSceneDataContextListener() {}

            /// Called when a scene is added to the context
        virtual void sceneAddedCallback(_Inout_ hkxScene* scene) {}
            /// Called when a scene is removed from the context
        virtual void sceneRemovedCallback(_Inout_ hkxScene* scene ) {}
};

    /// Context that controls what scene data viewers are registered and how they access hkxScene information.
class HK_EXPORT_COMMON hkxSceneDataContext: public hkReferencedObject,
                           public hkProcessContext
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_TOOLS);

            /// Initializes an empty context.
        hkxSceneDataContext();
            /// Destroys the context and removes all scenes.
        virtual ~hkxSceneDataContext();

            /// Register all scene data viewers
        static void HK_CALL registerAllSceneDataViewers();

            /// hkProcessContext interface
        virtual _Ret_z_ const char* getType();

            /// Adds a scene to the context.
        void addScene(_Inout_ hkxScene* scene );
            /// Removes a scene from the context.
        void removeScene(_Inout_ hkxScene* scene );
            /// Gets a list of scenes in the context.
        const hkArray<hkxScene*>& getScenes() const;

            /// Adds a listener to the context
        void addListener(_In_ hkxSceneDataContextListener* listener );
            /// Remove a listener from the context
        void removeListener(_In_ hkxSceneDataContextListener* listener );

            /// Add a texture search path for finding non-embedded textures
        void addTextureSearchPath(_In_z_ const char* path);
            /// Clear texture search paths
        void clearTextureSearchPaths();
            /// Get the current texture path array
        const hkArray<const char*>& getTextureSearchPaths() const;
            /// Set whether or not to allow mipmapping
        void setAllowTextureMipmap( hkBool on );
            /// Get whether or not to allow mipmapping
        bool getAllowTextureMipmap() const;

    protected:

            /// Scenes in this context
        hkArray<hkxScene*> m_scenes;

            /// Listeners in this context
        hkArray<hkxSceneDataContextListener*> m_listeners;

            /// Texture search paths
        hkArray<const char*> m_searchPaths;

            /// Allow mipmaps
        hkBool m_allowMipmap;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
