// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Visualize/hkProcess.h>
#include <Common/SceneData/VisualDebugger/hkxSceneDataContext.h>

    /// Displays all meshes in the hkxSceneDataContext
class hkxSceneViewer: public hkReferencedObject,
                      public hkProcess,
                      public hkxSceneDataContextListener
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_TOOLS);

            /// Creates a hkxSceneViewer.
        static hkProcess* HK_CALL create(const hkArray<hkProcessContext*>& contexts);

            /// Registers the hkxSceneViewer with the hkProcessFactory.
        static void HK_CALL registerViewer();

            /// Gets the tag associated with this viewer type
        virtual int getProcessTag() const HK_OVERRIDE { return s_tag; }

            /// The name of the viewer shown in the VDB
        static inline _Ret_z_ const char* HK_CALL getName() { return "Scene Data"; }

            /// Initializes the viewer
        hkxSceneViewer(_Inout_ hkxSceneDataContext* context );
            /// Destroys the viewer
        virtual ~hkxSceneViewer();

            /// Connects the viewer to scene
        virtual void sceneAddedCallback(_Inout_ hkxScene* scene ) HK_OVERRIDE;
            /// Disconnects the viewer from scene
        virtual void sceneRemovedCallback(_Inout_ hkxScene* scene ) HK_OVERRIDE;

            /// Raised after the viewer has been initialized
        virtual void init() HK_OVERRIDE;

    protected:

            /// Handle to the context which this viewer is connected to
        hkxSceneDataContext* m_context;

            /// Unique ID for the viewer
        static int s_tag;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
