// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/SceneData/Graph/hkxNode.h>


/// A relationship between a given mesh and a set of 'bones' (nodes in the scene
/// graph). Can be used to create more runtime specific structures after initial
/// export.
class HK_EXPORT_COMMON hkxSkinBinding : public hkReferencedObject
{
    //+version(2)
    public:

    HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
    HK_DECLARE_REFLECTION();

        hkxSkinBinding()  { }

    public:

            /// The mesh to be skinned.
        hkRefPtr< class hkxMesh > m_mesh;

            /// A mapping from mesh indices to hkxNode names.
        hkArray< hkStringPtr > m_nodeNames;

            /// The world transforms for the bind pose for each of the referenced bones above.
        hkArray<hkMatrix4> m_bindPose;

            /// The skin world transform when the skin was bound (world-from-skinMesh transform)
        hkMatrix4 m_initSkinTransform;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
