// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/SceneData/Graph/hkxNode.h>
#include <Common/SceneData/Selection/hkxNodeSelectionSet.h>
#include <Common/SceneData/Camera/hkxCamera.h>
#include <Common/SceneData/Light/hkxLight.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/SceneData/Material/hkxTextureInplace.h>
#include <Common/SceneData/Material/hkxTextureFile.h>
#include <Common/SceneData/Skin/hkxSkinBinding.h>
#include <Common/SceneData/Spline/hkxSpline.h>

/// Contains a modeller-agnostic representation of a scene, as exported by the Havok exporters from Max, Maya, or XSI.
class HK_EXPORT_COMMON hkxScene : public hkReferencedObject
{
    //+version(2)
public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
        HK_DECLARE_REFLECTION();

        hkxScene();
        virtual ~hkxScene();

        //
        // Members
        //
    public:

            /// A text string describing the modeller used to create this scene
        hkStringPtr m_modeller;

            /// The full path and filename of the asset that was exported to make this scene.
        hkStringPtr m_asset;

            /// The total length of the scene, in seconds. Assumes that when you are given
            /// key frames, they will be evenly spaced across this period.
        hkReal m_sceneLength;

      /// Original number of frames represented. May not be set for older exported scenes, so only valid if > 0.
        hkUint32 m_numFrames;

            /// Scene Graph root node
        hkRefPtr< class hkxNode > m_rootNode;

            /// Array of selection sets in the scene. Holds ref.
        hkArray< hkRefPtr<class hkxNodeSelectionSet> > m_selectionSets;

            /// Array of cameras in the scene. Holds ref.
        hkArray< hkRefPtr<class hkxCamera> > m_cameras;

            /// Array of cameras in the scene. Holds ref.
        hkArray< hkRefPtr<class hkxLight> > m_lights;

            /// Meshes in the scene. Holds ref.
        hkArray< hkRefPtr<class hkxMesh> > m_meshes;

            /// Materials in the scene. Holds ref.
        hkArray< hkRefPtr<class hkxMaterial> > m_materials;

            /// In place (loaded) textures in the scene. Holds ref.
        hkArray< hkRefPtr<class hkxTextureInplace> > m_inplaceTextures;

            /// External texture filenames. Holds ref.
        hkArray< hkRefPtr<class hkxTextureFile> > m_externalTextures;

            /// Extra mesh info required to bind a skin to a hierarchy. Holds ref.
        hkArray< hkRefPtr<class hkxSkinBinding> > m_skinBindings;

            /// Splines in the scene. Holds reference.
        hkArray< hkRefPtr<class hkxSpline> > m_splines;

            /// Transform applied to the scene
        hkMatrix3 m_appliedTransform;

            /// Recursively looks for a node by name (case insensitive), using depth-first search.
            /// Returns HK_NULL if not found, the node otherwise
        hkxNode* findNodeByName (_In_opt_z_ const char* name) const;

            /// Constructs the full path (parent-first list of nodes from the root to the node itself, both included).
            /// Returns HK_FAILURE if the node doesn't belong to this scene
        hkResult getFullPathToNode (_In_ const hkxNode* theNode, hkArray<const hkxNode*>& pathOut) const;

            /// Gets the worldFromNode transform of the given node, by concatenating
            /// the transforms of its parents. By default, it uses the first stored key.
            /// Returns HK_FAILURE if the node doesn't belong to this scene
        hkResult getWorldFromNodeTransform (_In_ const hkxNode* theNode, hkMatrix4& worldFromNodeOut, int key=0) const;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
