// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/SceneData/hkSceneData.h>
#include <Common/SceneData/Scene/hkxScene.h>

hkxScene::hkxScene()
: m_sceneLength (0),
  m_numFrames (0)
{
    m_appliedTransform.setIdentity();
}

hkxScene::~hkxScene()
{

}

hkxNode* hkxScene::findNodeByName (_In_opt_z_ const char* name) const
{
    if( (!name) || (!m_rootNode) )
    {
        return HK_NULL;
    }
    else if ( m_rootNode->m_name && (hkString::strCasecmp(m_rootNode->m_name, name)==0))
    {
        return m_rootNode;
    }
    else
    {
        return m_rootNode->findDescendantByName(name);
    }
}

hkResult hkxScene::getFullPathToNode(_In_ const hkxNode* theNode, hkArray<const hkxNode*>& pathOut) const
{
    return m_rootNode->getPathToNode (theNode, pathOut);
}

hkResult hkxScene::getWorldFromNodeTransform (_In_ const hkxNode* theNode, hkMatrix4& worldFromNodeOut, int key) const
{
    hkInplaceArray<const hkxNode*,32> path;
    hkResult result = getFullPathToNode(theNode, path);

    if (result.isFailure()) return HK_FAILURE;

    worldFromNodeOut.setIdentity();

    for (int i=0; i<path.getSize(); i++)
    {
        int nodeKey = (key < path[i]->m_keyFrames.getSize() ) ? key : path[i]->m_keyFrames.getSize() - 1;
        const hkMatrix4& parentFromChild = path[i]->m_keyFrames[nodeKey];
        worldFromNodeOut.mul(parentFromChild);
    }

    return HK_SUCCESS;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
