// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/SceneData/Mesh/hkxVertexBuffer.h>

/// This structure describes the memory layout and format of a vertex buffer.
/// Perhaps we should switch this for a hkReflect::Type and use the serialization framework?
class HK_EXPORT_COMMON hkxVertexUtil
{
    public:
            /// Returns the byte alignment of a particular element.
            /// Pass in one of the enumerated types above only
        static hkUlong HK_CALL getAlignment(hkxVertexDescription::DataUsage usage, const hkxVertexBuffer& buffer);

            /// Called by getAlignment(hkUint32 property, const hkxVertexBuffer& buffer), but
            /// can take any addr
        static hkUlong HK_CALL getAlignment(hkUlong addr);

            /// Used to check the bone indices bit width in a vertex buffer
        static hkxVertexDescription::DataType HK_CALL getBoneIndicesType( const hkRefPtr< hkxVertexBuffer >& vertexBuffer );

            /// Used to ensure that the bone indices in an existing vertex buffer are 16 bit wide
            /// Will return true if the vertex buffer has been re-allocated, and false otherwise.
        static bool HK_CALL reformatBoneIndicesTo16Bit( hkRefPtr< hkxVertexBuffer >& vertexBuffer );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
