// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/SceneData/Mesh/hkxVertexBuffer.h>
#include <Common/Base/Container/BitField/hkBitField.h>

class HK_EXPORT_COMMON hkxVertexAnimation : public hkReferencedObject
{
  //+version(0)
  public:

    HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
    HK_DECLARE_REFLECTION();

    inline hkxVertexAnimation();

    hkReal m_time; // in seconds, so (0..hkxScene::m_sceneLength scale normally)
    hkxVertexBuffer m_vertData; // vertex sub set (both in #num verts and in what is animated)
    hkArray<hkInt32> m_vertexIndexMap; // index in m_vertData back to original, as very rarely change all verts per frame. If becomes large mem hit, can set this to size 0 which would indicate a 1:1 map for above vert data

    struct UsageMap
    {
      HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA, UsageMap );
      HK_DECLARE_REFLECTION();

      hkEnum<hkxVertexDescription::DataUsage, hkUint16> m_use;
      hkUint8 m_useIndexOrig;  // origVertxBuffer->getElementDecl( m_use, m_useIndexOrig );
      hkUint8 m_useIndexLocal; // m_vertData->getElementDecl( m_use, m_useIndexLocal );
    };
    hkArray<UsageMap> m_componentMap;
};

/// A util class to keep track of all applied partial vertex anims on a vert buffer.
/// It does no interpolation, so is just a raw state as per last applied keys (used in exporters to see if new key needed per vert, etc.).
class HK_EXPORT_COMMON hkxVertexAnimationStateCache : public hkReferencedObject
{
  public:
    HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );

    // Will copy the vb assumming you will be animating it
    hkxVertexAnimationStateCache(_Inout_ hkxVertexBuffer* b, bool alterInPlace );
    hkxVertexAnimationStateCache(_In_ const hkxVertexBuffer* b);

    virtual ~hkxVertexAnimationStateCache();

     // will take all new vert data from anim and alter the cached vb with it
    void apply(_In_ const hkxVertexAnimation* anim, float interplotate = 0.f);

     // reset the cache back to base state
    void reset(_Inout_ hkxVertexBuffer* b, bool alterInPlace);

      // get the state. You can assume it has identical layout to the original.
    inline const hkxVertexBuffer& getState() const { return *m_state; }
    inline hkReal getKeyTime() const { return m_curKeyTime; }

    inline const hkBitField& getTouchedData() const { return m_alteredVerts; }

  protected:

    void copyState(_In_ const hkxVertexBuffer* vb);

    hkxVertexBuffer* m_state;
    hkBitField m_alteredVerts;

    hkBool m_ownState;
    hkReal m_curKeyTime;

};
#include <Common/SceneData/Mesh/hkxVertexAnimation.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
