// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/SceneData/Mesh/hkxMeshSection.h>
#include <Common/SceneData/Mesh/hkxIndexBuffer.h>

class hkxMesh;

struct HK_EXPORT_COMMON hkxBoneIndicesInt8Data
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkxBoneIndicesInt8Data);

    struct HK_EXPORT_COMMON BoneIndicesDataPtr
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkxBoneIndicesInt8Data::BoneIndicesDataPtr);

        hkUint8* m_boneIndicesPtr;
    };

    BoneIndicesDataPtr m_data;
    hkUint8 m_boneIndexStride;

    static const int m_maxNumBones = 256;

    void setBoneIndicesDataPtr(const hkxVertexBuffer& vb);
    hkUint16 getVertexBoneIndex(hkUint32 vertexIdx, hkUint32 influenceIdx) const;
    void setVertexBoneIndex(hkUint32 vertexIdx, hkUint32 influenceIdx, hkUint16 boneIdx);
};


struct HK_EXPORT_COMMON hkxBoneIndicesInt16Data
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkxBoneIndicesInt16Data);

    struct HK_EXPORT_COMMON BoneIndicesDataPtr
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkxBoneIndicesInt16Data::BoneIndicesDataPtr);

        hkUint16 *m_boneIndicesPtr;
    };

    BoneIndicesDataPtr m_data;
    hkUint8 m_boneIndexStride;

    static const int m_maxNumBones = 65536;

    void setBoneIndicesDataPtr(const hkxVertexBuffer& vb);
    hkUint16 getVertexBoneIndex(hkUint32 vertexIdx, hkUint32 influenceIdx) const;
    void setVertexBoneIndex(hkUint32 vertexIdx, hkUint32 influenceIdx, hkUint16 boneIdx);
};

class HK_EXPORT_COMMON hkxMeshSectionUtil
{
    public:
        typedef hkArray<hkInt16> hkBoneRemapping;

            /// Compute a new grouping for the hkxMeshSection that respects
            /// the fact that the number of bones at any one time in the
            /// rendering engine may be limited. Usually this limit can be
            /// 4 for non indexed matrix modes or around 20 indexable bones
            /// in the case of some PC Vertex Shaders. Delete the bone mappings
            /// arrays when you are done (one per output index buffer), you need
            /// this remapping to know which of the original bones each index buf
            /// requires and in what order.
            /// This function is slow and uses memory. Ideally this should
            /// be done as an optimization step on export and the resultant
            /// mesh used if the hardware supports / requires it.
            /// Returns true if it had to do anything.
        static void HK_CALL computeLimitedBoneSection(const hkxMeshSection& section,
            hkUint32 indexedBoneLimit, hkxMeshSection& newSection, hkArray<hkBoneRemapping*>& boneMatrixMap );

            /// Can call this to see if need to do computeLimitedBoneSection at all
        static int HK_CALL numUsedBones( const hkxMeshSection& section );

            /// As used by the CreateTangents filter etc, this function will create tangents as
            /// required, and also split vertices across mirror edges. The split vertex indices
            /// are added to a hkxVertexSelectionChannel in the mesh called "Mirrored UV Split Vertices"
        static void HK_CALL computeTangents( _Inout_ hkxMesh* mesh, bool splitVertices, _In_opt_z_ const char* nameHint = HK_NULL );

        static _Ret_maybenull_ hkxMesh* HK_CALL needTangents(_In_ const hkxMesh* mesh);

    protected:

        hkxMeshSectionUtil() { }

    private:

        template <class BoneIndicesDataInterface>
        static void computeLimitedBoneSection(const hkxMeshSection& section,
            hkUint32 indexedBoneLimit, hkxMeshSection& newSection, hkArray<hkBoneRemapping*>& boneMatrixMap);

        template <class BoneIndicesDataInterface>
        static int numUsedBones(const hkxMeshSection& section);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
