// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


#include <Common/SceneData/Mesh/hkxIndexBuffer.h>
#include <Common/SceneData/Mesh/hkxVertexBuffer.h>
#include <Common/SceneData/Mesh/hkxVertexAnimation.h>
#include <Common/SceneData/Material/hkxMaterial.h>
#include <Common/GeometryUtilities/Mesh/IndexedTransformSet/hkIndexedTransformSet.h>

/// A serialization wrapper for the relationship between a Vertex buffer and a set
/// of primitives.
class HK_EXPORT_COMMON hkxMeshSection : public hkReferencedObject
{
    //+version(5)
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
        HK_DECLARE_REFLECTION();

        hkxMeshSection() { }
        hkxMeshSection(const hkxMeshSection& other);

        struct CopyOptions
        {
            CopyOptions() : m_shareMaterials(true), m_shareIndexBuffers(true), m_shareVertexBuffers(true), m_shareVertexAnims(true), m_shareUserChannels(true), m_shareBoneMappings(true) { }
            bool m_shareMaterials;
            bool m_shareIndexBuffers;
            bool m_shareVertexBuffers;
            bool m_shareVertexAnims;
            bool m_shareUserChannels;
            bool m_shareBoneMappings;

            inline bool allSet() const { return m_shareMaterials && m_shareIndexBuffers && m_shareVertexBuffers && m_shareVertexAnims && m_shareUserChannels && m_shareBoneMappings; }
        };
        _Ret_notnull_ hkxMeshSection* copy( const CopyOptions& options ) const;

        //
        // Members
        //
    public:

            /// The vertex buffer used by this section of the mesh.
        hkRefPtr< class hkxVertexBuffer > m_vertexBuffer;

            /// The set of primitives that use the vertex buffer.
        hkArray< hkRefPtr<hkxIndexBuffer> > m_indexBuffers;

            /// The material to use for this mesh. May be a multi material or a plain single
            /// material, or null.
        hkRefPtr< class hkxMaterial > m_material;

            /// User channels are expected to contain per-vertex, per-edge or per-face information.
            /// It will remove ref on them
        hkArray< hkRefVariant > m_userChannels;

            /// A frame-based alteration to the vertex buffer above
            /// Used for vertex animations and morph targets
        hkArray< hkRefPtr<hkxVertexAnimation> > m_vertexAnimations;

            /// The points in time that there were keyframes in seconds.
        hkArray< float > m_linearKeyFrameHints;

            /// Output mappings from computeLimitedBoneSection.
        hkArray<hkMeshBoneIndexMapping> m_boneMatrixMap;

    public:

        /// Returns the number of triangles
        hkUint32 getNumTriangles () const;

        void getTriangleIndices (hkUint32 triIndex, hkUint32& indexAOut, hkUint32& indexBOut, hkUint32& indexCOut) const;


        //
        // Utility methods
        //

            /// Collects all vertex positions to the given array.
        void collectVertexPositions (hkArray<hkVector4>& verticesInOut) const;

            /// Constructs a hkGeometry object based on this mesh section and merges it with geometryInOut.
        void appendGeometry (struct hkGeometry& geometryInOut, int materialIndex = -1) const;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
