// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/SceneData/Attributes/hkxAttributeHolder.h>
#include <Common/SceneData/Mesh/hkxMeshSection.h>


/// The information needed to construct a mesh.
class HK_EXPORT_COMMON hkxMesh : public hkReferencedObject
{
    //+version(1)
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
        HK_DECLARE_REFLECTION();

        hkxMesh() { }
        virtual ~hkxMesh();

        class HK_EXPORT_COMMON UserChannelInfo : public hkxAttributeHolder
        {
        public:
            HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
            HK_DECLARE_REFLECTION();

            UserChannelInfo() { }
            UserChannelInfo( const UserChannelInfo& o ) : hkxAttributeHolder(o)
            {
                m_name = o.m_name;
                m_className = o.m_className;
            }

            UserChannelInfo& operator=( const UserChannelInfo& o )
            {
                m_name = o.m_name;
                m_className = o.m_className;
                return *this;
            }

            hkStringPtr m_name;
            hkStringPtr m_className;
        };

        struct CopyOptions
        {
            CopyOptions() :  m_shareMeshSections(true), m_shareUserChannels(true) {}

            hkxMeshSection::CopyOptions m_sectionOptions;

            bool m_shareMeshSections; // implies m_sectionOptions all true, will over rule
            bool m_shareUserChannels;
        };
        _Ret_notnull_ hkxMesh* copy( const CopyOptions& options ) const;

            //
        // Members
        //
    public:

        /// The sections (split by material).
        /// Meshes own the sections
        hkArray< hkRefPtr<hkxMeshSection> > m_sections;

        hkArray< hkRefPtr<hkxMesh::UserChannelInfo> > m_userChannelInfos;

        //
        // Utility methods
        //

            /// Traverses all the mesh sections and collects all vertex positions to the given array.
        void collectVertexPositions (hkArray<hkVector4>& verticesInOut) const;

            /// Traverses all the mesh sections and constructs a single geometry out of them which is merged with geometryInOut.
            /// If materialsInOut is null, the output geometry will not contain any material information. Otherwise, if the mesh
            /// section uses materials then are contained in materialsInOut, they will be re-used; materials that aren't already
            /// in materialsInOut will be added.
        void appendGeometry (struct hkGeometry& geometryInOut, _Inout_opt_ hkArray<class hkxMaterial*>* materialsInOut = HK_NULL) const;

            /// Removes the given user channel
        void removeUserChannel(int userChannelIndex);

            /// Finds the index of the (first) user channel for a given class name. Returns -1 if no matching
            /// user channel was found.
        int findUserChannelByClassName(_In_z_ const char* className) const;

            /// Finds the index of the (first) user channel for a given class type. Returns -1 if no matching
            /// user channel was found.
        template<typename T>
        int findUserChannelByClassType() const
        {
            return findUserChannelByClassName(hkReflect::getName<T>());
        }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
