// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/SceneData/hkSceneData.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>

hkxMesh::~hkxMesh()
{

}

void hkxMesh::collectVertexPositions (hkArray<hkVector4>& verticesInOut) const
{
    for (int si=0; si < m_sections.getSize(); ++si)
    {
        hkxMeshSection* section = m_sections[si];
        section->collectVertexPositions(verticesInOut);
    }
}

void hkxMesh::appendGeometry(hkGeometry& geometryInOut, _Inout_opt_ hkArray<hkxMaterial*>* materialsInOut) const
{
    int materialIndex = -1;

    for (int si=0; si < m_sections.getSize(); ++si)
    {
        int indexOffset = geometryInOut.m_vertices.getSize();

        if (materialsInOut)
        {
            hkxMaterial* material = m_sections[si]->m_material;
            materialIndex = materialsInOut->indexOf(material);
            if (materialIndex == -1)
            {
                materialIndex = materialsInOut->getSize();
                materialsInOut->pushBack(material);
            }
        }

        hkGeometry sectionGeometry;
        m_sections[si]->appendGeometry(sectionGeometry, materialIndex);

        // Increment indices for added geometries
        for (int t=0; t<sectionGeometry.m_triangles.getSize(); t++)
        {
            sectionGeometry.m_triangles[t].m_a += indexOffset;
            sectionGeometry.m_triangles[t].m_b += indexOffset;
            sectionGeometry.m_triangles[t].m_c += indexOffset;
        }

        // Merge arrays
        geometryInOut.m_vertices.insertAt(indexOffset, sectionGeometry.m_vertices.begin(), sectionGeometry.m_vertices.getSize());
        geometryInOut.m_triangles.insertAt(geometryInOut.m_triangles.getSize(), sectionGeometry.m_triangles.begin(), sectionGeometry.m_triangles.getSize());
    }
}

//
//  Removes the given user channel

void hkxMesh::removeUserChannel(int userChannelIndex)
{
    const int numChannels = m_userChannelInfos.getSize();
    if ( (userChannelIndex < 0) || (userChannelIndex >= numChannels) )
    {
        return; // Invalid user channel index!
    }

    // Remove info
    m_userChannelInfos.removeAt(userChannelIndex);

    // Remove actual data
    for (int si = m_sections.getSize() - 1; si >= 0; si--)
    {
        hkxMeshSection* section = m_sections[si];
        section->m_userChannels.removeAt(userChannelIndex);
    }
}

int hkxMesh::findUserChannelByClassName(_In_z_ const char* className) const
{
    const int numUserChannels = m_userChannelInfos.getSize();
    for (int i = 0; i < numUserChannels; ++i)
    {
        if (m_userChannelInfos[i]->m_className == className)
        {
            return i;
        }
    }

    return -1;
}

_Ret_notnull_ hkxMesh* hkxMesh::copy( const CopyOptions& options ) const
{
    hkxMesh* m = new hkxMesh();
    if (options.m_shareMeshSections)
    {
        m->m_sections = m_sections;
    }
    else
    {
        m->m_sections.setSize(m_sections.getSize());
        bool shareAllSectionData = options.m_sectionOptions.allSet();
        for (int c=0; c < m_sections.getSize(); ++c)
        {
            if (shareAllSectionData)
            {
                m->m_sections[c] = hkRefNew<hkxMeshSection>(new hkxMeshSection(*m_sections[c]));
            }
            else
            {
                m->m_sections[c] = hkRefNew<hkxMeshSection>(m_sections[c]->copy(options.m_sectionOptions));
            }
        }
    }

    if (options.m_shareUserChannels)
    {
        m->m_userChannelInfos = m_userChannelInfos;
    }
    else
    {
        m->m_userChannelInfos.setSize(m_userChannelInfos.getSize());
        for (int c=0; c < m_userChannelInfos.getSize(); ++c)
        {
            *(m->m_userChannelInfos[c]) = *(m_userChannelInfos[c]);
        }
    }

    return m;

}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
