// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/SceneData/hkSceneData.h>
#include <Common/SceneData/Mesh/hkxIndexBuffer.h>

/// Returns the number of triangles
int hkxIndexBuffer::getNumTriangles () const
{
    int numIndices = m_indices16.getSize() ? m_indices16.getSize() : m_indices32.getSize();

    switch ( m_indexType )
    {
        case hkxIndexBuffer::INDEX_TYPE_TRI_LIST:
        {
            return numIndices/3;
        }

        case hkxIndexBuffer::INDEX_TYPE_TRI_STRIP:
        {
            if (numIndices > 2)
            {
              return numIndices - 2;
            }
            break;
        }

        default:
            break;
    }

    return 0;
}

bool hkxIndexBuffer::getTriangleIndices (hkUint32 triIndex, hkUint32& indexAOut, hkUint32& indexBOut, hkUint32& indexCOut) const
{
    if ( m_indices16.getSize() )
    {
      // 16 bit indices
      switch ( m_indexType )
      {
        case hkxIndexBuffer::INDEX_TYPE_TRI_LIST:
        {
          HK_ON_DEBUG( if ((triIndex*3 + 2) < (hkUint32)m_indices16.getSize()) )
          {
            indexAOut = (hkUint32)m_indices16[triIndex*3];
            indexBOut = (hkUint32)m_indices16[triIndex*3+1];
            indexCOut = (hkUint32)m_indices16[triIndex*3+2];
            return true;
          }
          break;
        }

        case hkxIndexBuffer::INDEX_TYPE_TRI_STRIP:
        {
          HK_ON_DEBUG( if ((triIndex + 2) < (hkUint32)m_indices16.getSize()) )
          {
            indexAOut = (hkUint32)m_indices16[triIndex];
            indexBOut = (hkUint32)m_indices16[triIndex+1];
            indexCOut = (hkUint32)m_indices16[triIndex+2];
            return true;
          }
          break;
        }

      default: break;
      }
    }
    else if ( m_indices32.getSize() )
    {
      // 32 bit indices
      switch ( m_indexType )
      {
        case hkxIndexBuffer::INDEX_TYPE_TRI_LIST:
        {
          HK_ON_DEBUG( if ((triIndex*3 + 2) < (hkUint32)m_indices32.getSize()) )
          {
            indexAOut = m_indices32[triIndex*3];
            indexBOut = m_indices32[triIndex*3+1];
            indexCOut = m_indices32[triIndex*3+2];
            return true;
          }
          break;
        }

        case hkxIndexBuffer::INDEX_TYPE_TRI_STRIP:
        {
          HK_ON_DEBUG( if ((triIndex + 2) < (hkUint32)m_indices32.getSize()) )
          {
            indexAOut = m_indices32[triIndex];
            indexBOut = m_indices32[triIndex+1];
            indexCOut = m_indices32[triIndex+2];
            return true;
          }
          break;
        }

        default: break;
      }
    }

    indexAOut = HKX_INDEX_BUFFER_INVALID_INDEX;
    indexBOut = HKX_INDEX_BUFFER_INVALID_INDEX;
    indexCOut = HKX_INDEX_BUFFER_INVALID_INDEX;
    return false;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
