// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


#pragma once

// Mesh factory to create hkMemoryMeshShapes from hkxScene data

#include <Common/SceneData/Mesh/hkxMeshFactory.h>
#include <Common/GeometryUtilities/Mesh/Skin/hkSkinnedMeshShape.h>

class hkMemoryMeshSystem;

class HK_EXPORT_COMMON hkxMemoryMeshFactory : public hkxMeshFactory
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_EXPORT);

    public:

        hkxMemoryMeshFactory(_In_ hkMemoryMeshSystem* meshSystem);
        virtual ~hkxMemoryMeshFactory();

            // hkxMeshFactory methods
        virtual _Ret_maybenull_ hkMeshSystem* getMeshSystem() HK_OVERRIDE;
        virtual void extractShapes(_Inout_ hkRootLevelContainer* rootLevelContainer, hkStringMap<int>& extraGraphicsNodes, hkStringMap<hkMeshShape*>& shapesOut) HK_OVERRIDE;
        virtual void extractShapes(_Inout_ hkRootLevelContainer* rootLevelContainer, hkMap<hkUuid, int>& extraGraphicsNodes, hkMap<hkUuid, hkMeshShape*>& shapesOut ) HK_OVERRIDE;
        virtual void storeShapes(_Inout_ hkRootLevelContainer* rootLevelContainer, hkArray<const hkMeshShape*>& shapes ) HK_OVERRIDE;
        virtual const hkMatrix3& getTransform() const HK_OVERRIDE;
        virtual void setTransform( const hkMatrix3& transform ) HK_OVERRIDE;

            /// Creates a skinned mesh shape from the given mesh shapes and transforms. A single bone will drive each of the provided shapes.
            /// Currently, the implementation returns HK_NULL.
        virtual _Ret_notnull_ hkSkinnedMeshShape* createSkinnedMesh(_In_z_ const char* skinnedMeshName, _In_reads_(numMeshes) const hkMeshShape** meshShapesIn, _In_reads_(numMeshes) const hkQTransform* transformsIn, int numMeshes, int maxBonesPerSection) HK_OVERRIDE;

            /// Removes all the given shapes from the root level container
        virtual void removeShapes(_Inout_opt_ hkRootLevelContainer* rootLevelContainer, hkArray<const hkMeshShape*>& shapes) HK_OVERRIDE;

    public:

            /// Creates shapes based on the mesh data in hkxScene with the use of the supplied hkMemoryMeshSystem
        static void extractShapes(_In_ const hkRootLevelContainer* rootLevelContainer, hkStringMap<int>& extraGraphicsNodes, _Inout_ hkMemoryMeshSystem *meshSystem, hkStringMap<hkMeshShape*>& shapesOut );
        static void extractShapes(_In_ const hkRootLevelContainer* rootLevelContainer, hkMap<hkUuid, int>& extraGraphicsNodes, _Inout_ hkMemoryMeshSystem *meshSystem, hkMap<hkUuid, hkMeshShape*>& shapesOut );

    protected:

        hkRefPtr<hkMemoryMeshSystem> m_meshSystem;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
