// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


    /// Stores per-vertex float values
class HK_EXPORT_COMMON hkxVertexFloatDataChannel : public hkReferencedObject
{
    public:

        enum VertexFloatDimensions
        {
            FLOAT = 0,
            DISTANCE = 1,
            ANGLE = 2
        };

        enum VertexFloatScale
        {
            ORIGINAL = 0,
            RESCALE = 1,
        };

    public:

        HK_DECLARE_CLASS(hkxVertexFloatDataChannel, Reflect, New, Version(2));

        hkxVertexFloatDataChannel() : m_dimensions(FLOAT), m_scaleMin(0.0f), m_scaleMax(1.0f) { }

        int getNumVertexFloats() const { return m_perVertexFloats.getSize(); }

        void setVertexFloat(int index, hkFloat32 value)
        {
            m_perVertexFloats[index] = value;
        }

        hkFloat32 getVertexFloat(int index, VertexFloatScale scale) const
        {
            if(scale == RESCALE)
            {
                hkFloat32 scaleAmount = m_scaleMax - m_scaleMin;
                return m_scaleMin + m_perVertexFloats[index]* scaleAmount;

            }

            return m_perVertexFloats[index];
        }

        hkArray<hkFloat32>& getPerVertexFloats()
        {
            return m_perVertexFloats;
        }

    public:

        hkEnum< hkxVertexFloatDataChannel::VertexFloatDimensions, hkUint8> m_dimensions;

        hkReal m_scaleMin;
        hkReal m_scaleMax;

    protected:

        hkArray<hkFloat32> m_perVertexFloats;


};

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkxVertexFloatDataChannel::VertexFloatDimensions);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
