// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/SceneData/Mesh/hkxVertexBuffer.h>

/// Stores blend shapes array
class HK_EXPORT_COMMON hkxBlendShapeCollectionChannel : public hkReferencedObject
{
    //+version(1)
public:

    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);
    HK_DECLARE_REFLECTION();

    // [KeyFrame]
    //
    // KeyFrame is a geometry of channel in a given point-in-time
    // Idea is to have evaluator which gives you geometry of current channel by time-weight of this channel
    // Example would be like that:
    //
    // ChannelA equals to KeyFrameA when time weight is 0.2,
    // ChannelA equals to KeyFrameB when time weight is 0.5,
    // ChannelA equals to KeyFrameC when time weight is 1.0,
    //
    // if time weight would less than 0.2 then it will be equal to interpolated geometry between OriginanMesh and KeyFrameA,
    // if time weight would be 0.25 then it will be equal to interpolated geometry between KeyFrameA and KeyFrameB,
    // if time weight would be 0.8 then it will be equal to interpolated geometry between KeyFrameB and KeyFrameC,
    //
    struct KeyFrame
    {
        //+version(1)
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);
        HK_DECLARE_REFLECTION();

        hkStringPtr m_name;
        hkUint32 m_baseVertex; // offset in global vertex buffer
        hkUint32 m_vertexCount;
        hkDouble64 m_timeWeight; // from 0.00 to 100.00
    };

    // [Float Curve]
    //
    // Array of floats to represent curve-function conversion from time to timeWeight
    //

    struct FloatCurveKey
    {
        //+version(1)
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);
        HK_DECLARE_REFLECTION();

        hkStringPtr m_name;
        hkFloat32 m_value;
        hkInt64 m_time;
    };

    struct FloatCurve
    {
        //+version(1)
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);
        HK_DECLARE_REFLECTION();

        hkStringPtr m_name;
        hkArray<FloatCurveKey> m_values;
        hkInt64 m_timeStart;
        hkInt64 m_timeEnd;
    };

    // [Channel]
    //
    // Channel is evaluated geometry, it takes interpolated values from KeyFrames in given point of time,
    // by converting time to timeWeight by FloatCurve and bilinear-sample KeyFrame by this weight.

    struct Channel
    {
        //+version(1)
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);
        HK_DECLARE_REFLECTION();

        hkStringPtr m_name;
        hkArray<KeyFrame> m_keyFrames;
        hkArray<FloatCurve> m_curves; // every animation layer has different curve
    };

    // [Blend Shape]
    //
    // Blend shape is combination of channel's geometry like that:
    //
    //           BlendShape = ChannelA * Wa + ChannelB * Wb + ChannelC * Wc + ...
    //
    // where Wa, Wb, Wc,... - are channel weights (or sliders in UI)

    struct HK_EXPORT_COMMON BlendShape
    {
        //+version(1)
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);
        HK_DECLARE_REFLECTION();

        hkStringPtr m_name;
        hkArray<Channel> m_channnels;
    };

    hkStringPtr m_name;
    hkArray<BlendShape> m_blendShapes;
    hkxVertexBuffer m_vertData;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
