// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


/// A memory based (inplace in the import cinfo) texture. Limited representation at
/// the moment.
class HK_EXPORT_COMMON hkxTextureInplace : public hkReferencedObject
{
    //+version(1)
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
        HK_DECLARE_REFLECTION();

        hkxTextureInplace() { }

        /// Compares this texture with another. Returns true if they are equal
        bool equals(_In_ const hkxTextureInplace* other) const;

    public:

            /// The three letter filetype extension (BMP, PNG, GIF, etc)
        hkUint8 m_fileType[4];

            /// The raw data, as it would be from a file (still compressed etc.)
        hkArray<hkUint8> m_data;

            /// Name so we can set specific options to convert it in the pipeline
        hkStringPtr m_name;
        hkStringPtr m_originalFilename; // name from original material, so we can always get back to source
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
