// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/SceneData/hkSceneData.h>
#include <Common/SceneData/Material/hkxTextureInplace.h>

//
//  Compares this texture with another. Returns true if they are equal

bool hkxTextureInplace::equals(_In_ const hkxTextureInplace* other) const
{
    if ( hkString::memCmp(m_fileType, other->m_fileType, sizeof(m_fileType)) )  {   return false;   }
    if ( m_name.compareTo(other->m_name) )                                      {   return false;   }
    if ( m_originalFilename.compareTo(other->m_originalFilename) )              {   return false;   }

    const int len = m_data.getSize();
    if ( len != other->m_data.getSize() )                                       {   return false;   }
    if ( hkString::memCmp(m_data.begin(), other->m_data.begin(), len) )         {   return false;   }

    return true;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
