// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class HK_EXPORT_COMMON hkxMaterialShader : public hkReferencedObject
{
    //+version(1)
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
        HK_DECLARE_REFLECTION();

        hkxMaterialShader() { }

            /// Used by textures to hint at their usage.
        enum ShaderType
        {
            EFFECT_TYPE_INVALID,
            EFFECT_TYPE_UNKNOWN,
            EFFECT_TYPE_HLSL_INLINE, // As a source text file, built-in
            EFFECT_TYPE_CG_INLINE, // As a source text file, built-in
            EFFECT_TYPE_HLSL_FILENAME, // As a source text filename
            EFFECT_TYPE_CG_FILENAME, // As a source text filename
            EFFECT_TYPE_MAX_ID
        };

        //
        // Members
        //
    public:

            /// The name of the material shader
        hkStringPtr m_name;

            /// What type of shader is this?
        hkEnum<ShaderType, hkUint8> m_type;

            /// Entry points
        hkStringPtr m_vertexEntryName;
        hkStringPtr m_geomEntryName;
        hkStringPtr m_pixelEntryName;

        /// The data for the effect (source, or filename)
        hkArray<hkUint8> m_data;
};

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkxMaterialShader::ShaderType);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
