// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


class HK_EXPORT_COMMON hkxMaterialEffect : public hkReferencedObject
{
    //+version(1)
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
        HK_DECLARE_REFLECTION();

        hkxMaterialEffect() { }

            /// Used by textures to hint at their usage.
        enum EffectType
        {
            EFFECT_TYPE_INVALID,
            EFFECT_TYPE_UNKNOWN,
            EFFECT_TYPE_HLSL_FX_INLINE, // As a source text file
            EFFECT_TYPE_CG_FX_INLINE, // As a source text file
            EFFECT_TYPE_HLSL_FX_FILENAME, // As a source text file
            EFFECT_TYPE_CG_FX_FILENAME, // As a source text file
            EFFECT_TYPE_MAX_ID
        };

        //
        // Members
        //
    public:

            /// The name of the material effect
        hkStringPtr m_name;

            /// What type of effect is this?
        hkEnum<EffectType, hkUint8> m_type;

            /// The data for the effect (source, or filename)
        hkArray<hkUint8> m_data;
};

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkxMaterialEffect::EffectType);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
