// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/SceneData/hkSceneData.h>
#include <Common/SceneData/Material/hkxMaterial.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>

hkxMaterial::~hkxMaterial()
{

}

/// function object that routes calls to operator<
class _texStageLessFn
{
public:

    HK_INLINE hkBool operator() ( const hkxMaterial::TextureStage& a, const hkxMaterial::TextureStage& b )
    {
        return ((int)a.m_usageHint) < ((int)b.m_usageHint) || ( (a.m_usageHint == b.m_usageHint) && (a.m_tcoordChannel < b.m_tcoordChannel) );
    }
};


void hkxMaterial::sortTextureStageOrder()
{
    _texStageLessFn funktor;
    hkAlgorithm::insertionSort( m_stages.begin(), m_stages.getSize(), funktor); // Has to be a stable sort, so that can predict from modeller, based on depth first material traversal, the order in final material of shared hints and uv coords
}

// Adds a property to the material

void hkxMaterial::addProperty(int key, int value)
{
    if(!hasProperty(key))
    {
        Property * p = m_properties.expandBy(1);
        p->m_key = key;
        p->m_value = value;
    }
}

// Returns a property value

hkUint32 hkxMaterial::getProperty(int key) const
{
    const hkUint32 theKey = (hkUint32)key;
    for(int i = m_properties.getSize() - 1; i >= 0; i--)
    {
        const Property & p = m_properties[i];
        if(p.m_key == theKey)
            return p.m_value;
    }

    // Not found!
    HK_ASSERT_NO_MSG(0x6e6765d5, false);
    return 0xFFFFFFFF;
}

// Returns true if the material has the given property

hkBool hkxMaterial::hasProperty(int key) const
{
    const hkUint32 theKey = (hkUint32)key;
    for(int i = m_properties.getSize() - 1; i >= 0; i--)
    {
        const Property & p = m_properties[i];
        if(p.m_key == theKey)
            return true;
    }

    // Not found!
    return false;
}


//
//  Compares two materials

bool hkxMaterial::equals(_In_ const hkxMaterial* other) const
{
    // Compare scalar stuff
    const int numStages     = m_stages.getSize();
    const int numProps      = m_properties.getSize();
    const int numChildren   = m_subMaterials.getSize();

    if ( m_name.compareTo(other->m_name)                        ||
        (m_specularMultiplier != other->m_specularMultiplier)   ||
        (m_specularExponent != other->m_specularExponent)       ||
        (m_uvMapAlgorithm != other->m_uvMapAlgorithm)           ||
        (m_transparency != other->m_transparency)               ||
        (m_userData != other->m_userData)                       ||
        (m_uvMapRotation != other->m_uvMapRotation)             ||
        (m_uvMapScale[0] != other->m_uvMapScale[0])             ||
        (m_uvMapScale[1] != other->m_uvMapScale[1])             ||
        (m_uvMapOffset[0] != other->m_uvMapOffset[0])           ||
        (m_uvMapOffset[1] != other->m_uvMapOffset[1])           ||
        (m_extraData != other->m_extraData)                     ||
        (numChildren != other->m_subMaterials.getSize())        ||
        (numStages != other->m_stages.getSize())                ||
        (numProps != other->m_properties.getSize()) )
    {
        return false;
    }

    // Compare SIMD stuff
    hkSimdReal eps = hkSimdReal_Eps;
    if ( !m_diffuseColor.allEqual<4>(other->m_diffuseColor, eps) )      {   return false;   }
    if ( !m_ambientColor.allEqual<4>(other->m_ambientColor, eps) )      {   return false;   }
    if ( !m_specularColor.allEqual<4>(other->m_specularColor, eps) )    {   return false;   }
    if ( !m_emissiveColor.allEqual<4>(other->m_emissiveColor, eps) )    {   return false;   }

    // Compare stages
    for (int si = 0; si < numStages; si++)
    {
        const TextureStage& ts = m_stages[si];
        const TextureStage& otherTs = other->m_stages[si];

        if ( ts.m_tcoordChannel != otherTs.m_tcoordChannel )            {   return false;   }
        if ( ts.m_usageHint != otherTs.m_usageHint )                    {   return false;   }
        if ( ts.m_texture != otherTs.m_texture )                        {   return false;   }
    }

    // Compare properties
    for (int pi = 0; pi < numProps; pi++)
    {
        const Property& p = m_properties[pi];
        if ( !other->hasProperty(p.m_key) || (other->getProperty(p.m_key) != p.m_value) )
        {
            return false;
        }
    }

    // Compare sub-materials
    for (int ci = 0; ci < numChildren; ci++)
    {
        if ( !m_subMaterials[ci]->equals(other->m_subMaterials[ci]) )
        {
            return false;
        }
    }

    // Success!
    return true;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
