// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Types/Color/hkColor.h>

/// The information needed to construct a simple light.
class HK_EXPORT_COMMON hkxLight : public hkReferencedObject
{
    //+version(4)
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
        HK_DECLARE_REFLECTION();

        hkxLight() { }

            /// Used to specify the type of the light.
        enum LightType
        {
                ///
            POINT_LIGHT,
                ///
            DIRECTIONAL_LIGHT,
                ///
            SPOT_LIGHT
        };

    public:

            /// The type of the light.
        hkEnum<LightType, hkInt8> m_type;

            /// The position (used for point and spot lights).
        hkVector4 m_position;

            /// The direction (used for directional and spot lights).
        hkVector4 m_direction;

            /// The RGB value of the light color.
        hkColor::Argb m_color;

            /// The inner angle, in radians of the spot light.
        hkReal m_innerAngle;

            /// The outer angle, in radians of the spot light.
        hkReal m_outerAngle;

            /// Range of influence
        hkReal m_range;

            /// Fade start (use decay rate for attenuation)
        hkReal m_fadeStart;

            /// Fade end
        hkReal m_fadeEnd;

            /// Decay rate (0 = no decay (currently not supported), 1 = linear, 2 = quadratic, 3 = cubic, ...)
        hkInt16 m_decayRate;

            /// Intensity multiplier (1 is default)
        hkReal m_intensity;

            /// Does it cast shadows
        hkBool m_shadowCaster;
};

HK_REFLECT_ENUM(HK_EXPORT_COMMON, hkxLight::LightType);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
