// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/SceneData/Attributes/hkxAttributeHolder.h>
#include <Common/Base/Types/Uuid/hkUuid.h>

/// A node in a scene graph
class HK_EXPORT_COMMON hkxNode : public hkxAttributeHolder
{
    //+version(5)
    public:

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
        HK_DECLARE_REFLECTION();

        /// Constructor
        hkxNode();

        virtual ~hkxNode();

            /// This structure describes a note track annotation ( text and time ).
            /// AnnotationData is DEPRECATED. Use hkxAttribute data, and look for animated strings types
        struct AnnotationData
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA, hkxNode::AnnotationData );
            HK_DECLARE_REFLECTION();

            AnnotationData() {}

                /// annotation time stamp.
            hkReal m_time;

                /// A string description of the event
            hkStringPtr m_description;
        };

        template<typename T>
        T* hasA() const
        {
            return hkDynCast<T>(m_object);
        }

        //
        // Members
        //
    public:

            /// Human readable name this object.
        hkStringPtr m_name;

            /// A unique identifier for this node
        hkUuid m_uuid;

            /// The object at this node, if one (mesh, skin, light, camera, etc.).
            /// Will assume a reference to the child (will remove ref on dtor)
        hkRefVariant m_object;

            /// Raw keyframe data
        hkArray< hkMatrix4 > m_keyFrames;

        /// The children of this node. This link forms the scene graph. Will assume a reference to the child (will remove ref on dtor)
        hkArray< hkRefPtr<class hkxNode> > m_children;

            /// Annotation Data for this node
        hkArray< struct hkxNode::AnnotationData > m_annotations;

            /// The points in time that there were keyframes in seconds.
        hkArray<float> m_linearKeyFrameHints;

            /// User data
        hkStringPtr m_userProperties;

            /// Selection flag
        hkBool m_selected;

            /// Is bone or joint. As not all bones will be connected to skins, can be handy to tell them apart
        hkBool m_bone;

            /// Looks for the first child that matches the given name (case insensitive)
        _Ret_maybenull_ hkxNode* findChildByName(_In_opt_z_ const char* childName) const;

            /// Recursively looks for the first descendant with each name (case insensitive). This is done depth-first.
        _Ret_maybenull_ hkxNode* findDescendantByName(_In_opt_z_ const char* name) const;

            /// Recursively looks for the first descendant with the given UUID. This is done depth-first.
        _Ret_maybenull_ hkxNode* findDescendantByUuid(const hkUuid& uuidIn) const;

            /// Recursively looks for the 'oldObject' and replace it with 'newObject'.
        void replaceAllObjects(_In_ const hkReferencedObject* oldObject, _In_ const hkReferencedObject* newObject );

            /// Constructs a path (parent-first list of nodes from this one to the node we search, both included).
            /// Returns HK_FAILURE if the node is not a descendant of this
        hkResult getPathToNode (_In_ const hkxNode* theNode, hkArray<const hkxNode*>& pathOut) const;
        hkResult getPathToNode (_In_z_ const char* nodeName, hkArray<const hkxNode*>& pathOut) const;

            /// Recursively counts the number of descendants
        int getNumDescendants () const;

            /// Search the node and its children for a hkVariant containing the specified object.
            /// This is done depth-first.
        hkRefVariant findVariantByObject(_In_ const hkReferencedObject* object ) const;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
