// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/SceneData/hkSceneData.h>
#include <Common/SceneData/Graph/hkxNode.h>

//
//  Constructor

hkxNode::hkxNode()
:   m_selected(false)
,   m_bone(false)
{
    m_uuid.setRandom();
}

hkxNode::~hkxNode()
{

}

_Ret_maybenull_ hkxNode* hkxNode::findChildByName(_In_opt_z_ const char* childName) const
{
    if( !childName )
    {
        return HK_NULL;
    }

    for (int i=0; i<m_children.getSize(); i++)
    {
        hkxNode* child = m_children[i];
        if( child->m_name && hkString::strCasecmp(child->m_name, childName)==0 )
        {
            return child;
        }
    }

    return HK_NULL;
}

_Ret_maybenull_ hkxNode* hkxNode::findDescendantByName(_In_opt_z_ const char* name) const
{
    if( !name )
    {
        return HK_NULL;
    }

    for (int i=0; i<m_children.getSize(); i++)
    {
        hkxNode* child = m_children[i];

        if( child->m_name && hkString::strCasecmp(child->m_name, name)==0 )
        {
            return child;
        }
        else
        {
            hkxNode* descendant = child->findDescendantByName(name);
            if (descendant != HK_NULL)
            {
                return descendant;
            }
        }
    }

    return HK_NULL;
}

//
//  Recursively looks for the first descendant with the given UUID. This is done depth-first.

_Ret_maybenull_ hkxNode* hkxNode::findDescendantByUuid(const hkUuid& uuidIn) const
{
    const int numChildren = m_children.getSize();

    for (int i = 0; i < numChildren; i++)
    {
        hkxNode* child = m_children[i];

        if ( child->m_uuid == uuidIn )
        {
            return child;
        }

        hkxNode* descendant = child->findDescendantByUuid(uuidIn);
        if ( descendant )
        {
            return descendant;
        }
    }

    return HK_NULL;
}

hkResult hkxNode::getPathToNode(_In_ const hkxNode* theNode, hkArray<const hkxNode*>& pathOut) const
{
    pathOut.pushBack(this);

    if (this == theNode)
    {
        return HK_SUCCESS;
    }

    hkResult result = HK_FAILURE;

    for (int i=0; i<m_children.getSize(); i++)
    {
        result = m_children[i]->getPathToNode(theNode, pathOut);
        if (result.isSuccess()) break;
    }

    if (result.isFailure())
    {
        pathOut.popBack();
    }

    return result;
}

hkResult hkxNode::getPathToNode(_In_z_ const char* nodeName, hkArray<const hkxNode*>& pathOut) const
{
    pathOut.pushBack(this);

    if (this->m_name.compareTo(nodeName) == 0)
    {
        return HK_SUCCESS;
    }

    hkResult result = HK_FAILURE;

    for (int i=0; i<m_children.getSize(); i++)
    {
        result = m_children[i]->getPathToNode(nodeName, pathOut);
        if (result.isSuccess()) break;
    }

    if (result.isFailure())
    {
        pathOut.popBack();
    }

    return result;
}

hkRefVariant hkxNode::findVariantByObject(_In_ const hkReferencedObject* object ) const
{
    if( m_object == object )
    {
        return m_object;
    }

    for( int i=0; i < m_children.getSize(); i++ )
    {
        hkRefVariant var = m_children[i]->findVariantByObject( object );
        if( var )
        {
            return var;
        }
    }

    return HK_NULL;
}


void hkxNode::replaceAllObjects(_In_ const hkReferencedObject* oldObject, _In_ const hkReferencedObject* newObject )
{
    if( m_object == oldObject )
    {
        m_object = newObject;
    }

    for( int i=0; i < m_children.getSize(); i++ )
    {
        m_children[i]->replaceAllObjects( oldObject, newObject );
    }
}

int hkxNode::getNumDescendants () const
{
    int numDescendants = m_children.getSize();

    for (int i=0; i<m_children.getSize(); i++)
    {
        numDescendants+=m_children[i]->getNumDescendants();
    }

    return numDescendants;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
