// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/SceneData/Blob/hkxBlob.h>
#include <Common/GeometryUtilities/Mesh/hkMeshShape.h>

    /// A storage only mesh shape implementation. The stored data is a blob.
class HK_EXPORT_COMMON hkxBlobMeshShape : public hkMeshShape
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);
        HK_DECLARE_REFLECTION();

    public:

            /// Constructor
        hkxBlobMeshShape()
        :   hkMeshShape()
        ,   m_name(HK_NULL)
        {}

    public:

            /// Returns the amount of sections
        virtual int getNumSections() const { return -1; }

            /// Gets information about a section
        virtual void lockSection(int sectionIndex, hkUint8 accessFlags, hkMeshSection& sectionOut) const {}

            /// Unlocks a mesh section.
        virtual void unlockSection(const hkMeshSection& section) const {}

            /// Returns an optional name of the mesh shape
        virtual _Ret_maybenull_z_ const char* getName() const { return m_name; }

            /// Sets an optional name
        virtual void setName(_In_opt_z_ const char* n) { m_name = n; }

    public:

            /// The mesh shape data, as a blob
        hkxBlob m_blob;

            /// The name
        hkStringPtr m_name;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
