// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/SceneData/Attributes/hkxSparselyAnimatedInt.h>


class HK_EXPORT_COMMON hkxEnum : public hkReferencedObject
{
    //+version(0)
public:

    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA);
    HK_DECLARE_REFLECTION();

    hkxEnum() { }

    /// Get the name of the item with value val.
    /// Not to be confused with the i'th item.
    hkResult getNameOfValue( int val, _Outptr_result_z_ const char** name ) const;

    /// Get the value of the item named name (note: case insensitive).
    /// Not to be confused with the index of the item.
    hkResult getValueOfName(_In_z_ const char* name, _Out_ int* val) const;

    struct Item
    {
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SCENE_DATA, Item);
        HK_DECLARE_REFLECTION();

        Item( ) { }
        Item( int v, const char* n) : m_value(v), m_name(n) { }

        int m_value;
        hkStringPtr m_name;
    };

    hkArray<struct hkxEnum::Item> m_items;

};

    /// An hkxSparselyAnimatedEnum stores the values associated with an hkxAttribute of type enum.
    /// This is the same as an hkxSparselyAnimatedInt with extra information about the conversion from int->string (enum), using
    /// an hkxEnum object for that.
class HK_EXPORT_COMMON hkxSparselyAnimatedEnum : public hkxSparselyAnimatedInt
{
    //+version(1)
public:

    HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
    HK_DECLARE_REFLECTION();

    hkxSparselyAnimatedEnum() { }

    hkRefPtr<hkxEnum> m_enum; // int value in parent class
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
