// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once


    /// An hkxSparselyAnimatedBool stores the values associated with an hkxAttribute of type bool. The animation of values is stored as
    /// pairs (time, value).
class HK_EXPORT_COMMON hkxSparselyAnimatedBool : public hkReferencedObject
{
    //+version(1)
public:

    HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
    HK_DECLARE_REFLECTION();

    hkxSparselyAnimatedBool() { }

        /// The array of sampled bools. The array can be of any length but
        /// the time stamps in the m_times array must be of the same length
        /// as there is a one to one mapping between the two arrays.
    hkArray<hkBool> m_bools;

        /// The array of times associated with teach of the values in m_bools.
    hkArray<float> m_times;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
