// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/SceneData/Attributes/hkxAttributeGroup.h>

class HK_EXPORT_COMMON hkxAttributeHolder : public hkReferencedObject
{
    //+version(2)
public:

    HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA );
    HK_DECLARE_REFLECTION();

    hkxAttributeHolder() { }
    hkxAttributeHolder(const hkxAttributeHolder& other);
    virtual ~hkxAttributeHolder();

        /// Attributes associated with this node.
        /// You can use hkxAttribute::findObjectByName and related methods
        /// to search the array for a given attribute.
        /// They are organized by groups, each group with a string type identifier
    hkArray<struct hkxAttributeGroup> m_attributeGroups;

        /// Looks for an attribute group by name
    _Ret_maybenull_ const hkxAttributeGroup* findAttributeGroupByName(_In_opt_z_ const char* name) const;

        /// Search an array of attributes for one by name, and optionally
        /// check the type of that attribute to make sure it matches the
        /// given class. If no attribute matches by name (and by class if given)
        /// it will return HK_NULL.
        /// Will search all groups;
    _Ret_maybenull_ hkReferencedObject* findAttributeObjectByName(_In_opt_z_ const char* name, _In_ const hkReflect::Type* type = HK_NULL) const;

        /// Search the attributes for one by name and return the variant
        /// of that attribute. hkVariant.m_object is HK_NULL if not found.
        /// Will search all groups;
    hkRefVariant findAttributeVariantByName(_In_opt_z_ const char* name ) const;

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
