// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/SceneData/hkSceneData.h>
#include <Common/SceneData/Attributes/hkxAttributeHolder.h>

hkxAttributeHolder::hkxAttributeHolder(const hkxAttributeHolder& other)
: hkReferencedObject(other)
{
    m_attributeGroups = other.m_attributeGroups;
}

hkxAttributeHolder::~hkxAttributeHolder()
{
    // Make sure we release all mem in our owned groups

}

_Ret_maybenull_ const hkxAttributeGroup* hkxAttributeHolder::findAttributeGroupByName(_In_opt_z_ const char* name) const
{
    if( !name )
    {
        return HK_NULL;
    }

    for (int j=0; j < m_attributeGroups.getSize(); ++j)
    {
        const hkxAttributeGroup& group = m_attributeGroups[j];
        if ( group.m_name && hkString::strCasecmp(group.m_name, name)==0 )
        {
            return &group;
        }
    }
    return HK_NULL;
}


hkRefVariant hkxAttributeHolder::findAttributeVariantByName(_In_opt_z_ const char* name) const
{
    if( name )
    {
        for (int j=0; j < m_attributeGroups.getSize(); ++j)
        {
            const hkxAttributeGroup& g = m_attributeGroups[j];
            hkRefVariant var = g.findAttributeVariantByName( name );
            if (var)
                return var;
        }
    }
    hkVariant v;
    return v;
}

_Ret_maybenull_
hkReferencedObject* hkxAttributeHolder::findAttributeObjectByName(_In_opt_z_ const char* name, _In_ const hkReflect::Type* type) const
{
    if( !name )
    {
        return HK_NULL;
    }

    hkRefVariant var = findAttributeVariantByName( name );

    // compare class by name so that it deals with serialized classes etc better (for instance in the filters)
    if (var && (!type || var.getType()->extendsOrEquals(type)))
    {
        return var.val();
    }

    return HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
