// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/SceneData/Attributes/hkxAttribute.h>

#include <Common/SceneData/Attributes/hkxSparselyAnimatedBool.h>
#include <Common/SceneData/Attributes/hkxSparselyAnimatedEnum.h>
#include <Common/SceneData/Attributes/hkxSparselyAnimatedInt.h>
#include <Common/SceneData/Attributes/hkxSparselyAnimatedString.h>
#include <Common/SceneData/Attributes/hkxAnimatedFloat.h>
#include <Common/SceneData/Attributes/hkxAnimatedVector.h>
#include <Common/SceneData/Attributes/hkxAnimatedQuaternion.h>
#include <Common/SceneData/Attributes/hkxAnimatedMatrix.h>


    /// Attribute groups are associated to hkxNodes and contain an array of hkxAttribute under a common heading.
    /// They usually represent a set of data associated with a node as a unit. For example, rigid body data.
struct HK_EXPORT_COMMON hkxAttributeGroup
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SCENE_DATA, hkxAttributeGroup );
    HK_DECLARE_REFLECTION();

    hkxAttributeGroup() {}
    hkxAttributeGroup( const hkxAttributeGroup& other ) { *this = other; }

    hkxAttributeGroup& operator=( const hkxAttributeGroup& other );

        /// The name of the attribute group - for example "hkpRigidBody".
    hkStringPtr m_name;

        /// The array of individual attributes in the group.
    hkArray<struct hkxAttribute> m_attributes;


    /*
    ** Get attribute value. Assumes non-animated attributes (takes first value)
    ** Use find...() methods to get full access to attribute animation
    */

        /// Retrieve the bool value of an attribute (case insensitive). Returns HK_FAILURE if not found (supports Bool, Int).
    hkResult getBoolValue (_In_z_ const char* name, bool warnIfNotFound, hkBool& boolOut) const;

        /// Retrieve the int value of an attribute (case insensitive). Returns HK_FAILURE if not found (supports Int, Enum, Bool).
    hkResult getIntValue (_In_z_ const char* name, bool warnIfNotFound, int& intOut) const;

        /// Retrieve the (unsigned) int value of an attribute (case insensitive). Returns HK_FAILURE if not found (supports Int, Enum, Bool).
    hkResult getIntValue (_In_z_ const char* name, bool warnIfNotFound, hkUint32& intOut) const;

        /// Retrieve the string value an attribute (case insensitive). Returns HK_FAILURE if not found (supports String, Enum).
    hkResult getStringValue (_In_z_ const char* name, bool warnIfNotFound, _Outref_ const char*& stringOut) const;

        /// Retrieve the value of a float attribute (case insensitive). Returns HK_FAILURE if not found (or not the right type).
    hkResult getFloatValue (_In_z_ const char* name, bool warnIfNotFound, float& floatOut) const;

        /// Retrieve the value of a vector attribute (case insensitive). Returns HK_FAILURE if not found (or not the right type).
    hkResult getVectorValue (_In_z_ const char* name, bool warnIfNotFound, hkVector4& vectorOut) const;

        /// Retrieve the value of a quaternion attribute (case insensitive). Returns HK_FAILURE if not found (or not the right type).
    hkResult getQuaternionValue (_In_z_ const char* name, bool warnIfNotFound, hkQuaternion& quaternionOut) const;

        /// Retrieve the value of a matrix attribute (case insensitive). Returns HK_FAILURE if not found (or not the right type).
    hkResult getMatrixValue (_In_z_ const char* name, bool warnIfNotFound, hkMatrix4& matrixOut) const;

    /*
    ** Search for attribute by name and type
    */

        /// Utility method (case insensitive), returns NULL if attribute wasn't found or it's the wrong type.
    _Ret_maybenull_ hkxSparselyAnimatedBool* findBoolAttributeByName (_In_z_ const char* name) const;

        /// Utility method (case insensitive), returns NULL if attribute wasn't found or it's the wrong type.
    _Ret_maybenull_ hkxSparselyAnimatedInt* findIntAttributeByName (_In_z_ const char* name) const;

        /// Utility method (case insensitive), returns NULL if attribute wasn't found or it's the wrong type.
    _Ret_maybenull_ hkxSparselyAnimatedEnum* findEnumAttributeByName (_In_z_ const char* name) const;

        /// Utility method (case insensitive), returns NULL if attribute wasn't found or it's the wrong type.
    _Ret_maybenull_ hkxSparselyAnimatedString* findStringAttributeByName (_In_z_ const char* name) const;

        /// Utility method (case insensitive), returns NULL if attribute wasn't found or it's the wrong type.
    _Ret_maybenull_ hkxAnimatedFloat* findFloatAttributeByName (_In_z_ const char* name) const;

        /// Utility method (case insensitive), returns NULL if attribute wasn't found or it's the wrong type.
    _Ret_maybenull_ hkxAnimatedVector* findVectorAttributeByName (_In_z_ const char* name) const;

        /// Utility method (case insensitive), returns NULL if attribute wasn't found or it's the wrong type.
    _Ret_maybenull_ hkxAnimatedQuaternion* findQuaternionAttributeByName (_In_z_ const char* name) const;

        /// Utility method (case insensitive), returns NULL if attribute wasn't found or it's the wrong type.
    _Ret_maybenull_ hkxAnimatedMatrix* findMatrixAttributeByName (_In_z_ const char* name) const;

    /*
    ** Generic attribute search
    */

        /// Finds an attribute by name (case insensitive), returns index.
    int findAttributeIndexByName (_In_z_ const char* name ) const;

        /// Finds an attribute by name (case insensitive), returns variant.
    hkRefVariant findAttributeVariantByName (_In_z_ const char* name ) const;

        /// Finds an attribute by name (case insensitive), returns object (value). Can (optionally) check the type.
    _Ret_maybenull_ hkReferencedObject* findAttributeObjectByName(_In_z_ const char* name, _In_opt_ const hkReflect::Type* type = HK_NULL) const;

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
