// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once


/// For more explanation of why this class declaration is in the SDK, refer to EXP-1656 and EXP-1655.
/// This class is used to communicate information between the "Align Scene To Node"
/// and the "Create Animations" filters.
///
/// Describes the align scene to node options.
/// This class is an exact mirror of the hctAlignSceneToNodeOptions class. Please only update one with a similar change to the other
class HK_EXPORT_COMMON hkAlignSceneToNodeOptions : public hkReferencedObject
{
    //+version(2)
    public:

        HK_DECLARE_REFLECTION();
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_ANIMATION);

        hkAlignSceneToNodeOptions();

        void setNodeName(_In_z_ const char* name );
        const hkStringPtr& getNodeName() const;

        //
        // Members
        //
    public:

        hkBool m_invert;
        hkBool m_transformPositionX;
        hkBool m_transformPositionY;
        hkBool m_transformPositionZ;
        hkBool m_transformRotation;
        hkBool m_transformScale;
        hkBool m_transformSkew;
        hkInt32 m_keyframe;

    private:

        hkStringPtr m_nodeName;

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
