// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


static HK_INLINE hkSimdReal hkVector4UtilInternal::halfSurfaceArea( const hkAabb& aabb )
{
    hkVector4 l, u;
    l.setSub( aabb.m_max, aabb.m_min );
    u.setPermutation<hkVectorPermutation::YZXW>( l );
    return l.dot<3>( u );
}

static HK_INLINE hkSimdReal hkVector4UtilInternal::surfaceArea( const hkAabb& aabb )
{
    return halfSurfaceArea( aabb ) * hkSimdReal_2;
}

//
#ifndef HK_VECTOR4UTIL_INTERNAL_overlaps6
HK_INLINE hkBool32 hkVector4UtilInternal::overlaps6( const hkAabb& aabbA, const hkAabb& aabbB, const hkTransform& BtoA, const hkTransform& AtoB )
{
    hkVector4   centerA;    centerA.setAdd( aabbA.m_min, aabbA.m_max );
    hkVector4   lengthA;    lengthA.setSub( aabbA.m_max, aabbA.m_min );

    hkSimdReal half = hkSimdReal::getConstant<HK_QUADREAL_INV_2>();
    centerA.mul( half );    lengthA.mul( half );

    hkVector4   heXA; heXA.setMul( lengthA.getComponent<0>(), AtoB.getColumn<0>() );
    hkVector4   heYA; heYA.setMul( lengthA.getComponent<1>(), AtoB.getColumn<1>() );
    hkVector4   heZA; heZA.setMul( lengthA.getComponent<2>(), AtoB.getColumn<2>() );
    heXA.setAbs( heXA );    heYA.setAbs( heYA );    heZA.setAbs( heZA );

    hkVector4   maxAinB;    maxAinB.setAdd( heXA, heYA );   maxAinB.add( heZA );

    hkVector4   centerAinB; centerAinB._setTransformedPos( AtoB, centerA );
    hkVector4   minAinB;    minAinB.setNeg<4>( maxAinB );

    maxAinB.add( centerAinB );  minAinB.add( centerAinB );

    hkVector4Comparison mincompB = minAinB.greater( aabbB.m_max );
    hkVector4Comparison maxcompB = aabbB.m_min.greater( maxAinB );
    hkVector4Comparison compB; compB.setOr( mincompB, maxcompB );

    if ( compB.anyIsSet<hkVector4ComparisonMask::MASK_XYZ>() )
    {
        return 0;
    }

    hkVector4   centerB;    centerB.setAdd( aabbB.m_min, aabbB.m_max );
    hkVector4   lengthB;    lengthB.setSub( aabbB.m_max, aabbB.m_min );

    centerB.mul( half );    lengthB.mul( half );

    hkVector4   heXB; heXB.setMul( lengthB.getComponent<0>(), BtoA.getColumn<0>() );
    hkVector4   heYB; heYB.setMul( lengthB.getComponent<1>(), BtoA.getColumn<1>() );
    hkVector4   heZB; heZB.setMul( lengthB.getComponent<2>(), BtoA.getColumn<2>() );
    heXB.setAbs( heXB );    heYB.setAbs( heYB );    heZB.setAbs( heZB );

    hkVector4   maxBinA;    maxBinA.setAdd( heXB, heYB ); maxBinA.add( heZB );

    hkVector4   centerBinA; centerBinA._setTransformedPos( BtoA, centerB );
    hkVector4   minBinA;    minBinA.setNeg<4>( maxBinA );

    maxBinA.add( centerBinA );  minBinA.add( centerBinA );

    hkVector4Comparison mincompA = minBinA.lessEqual( aabbA.m_max );
    hkVector4Comparison maxcompA = aabbA.m_min.lessEqual( maxBinA );
    hkVector4Comparison compA; compA.setAnd( mincompA, maxcompA );

    return compA.allAreSet<hkVector4ComparisonMask::MASK_XYZ>();
}
#endif

#ifndef HK_VECTOR4UTIL_INTERNAL_intersectRay
HK_INLINE hkBool32 hkVector4UtilInternal::intersectRay( const hkAabb& aabb, hkVector4Parameter rayInvDir, hkSimdRealParameter maxFraction )
{
    hkVector4 dNearTemp;    dNearTemp.setMul( aabb.m_min, rayInvDir );
    hkVector4 dFarTemp;     dFarTemp.setMul( aabb.m_max, rayInvDir );

    hkVector4 dNear;        dNear.setMin( dNearTemp, dFarTemp );
    hkVector4 dFar;         dFar.setMax( dNearTemp, dFarTemp );

    hkVector4 nearest;  nearest.setXYZ_0( dNear );
    hkVector4 farthest; farthest.setXYZ_W( dFar, maxFraction );

    const hkSimdReal nearClamped = nearest.horizontalMax<4>();
    const hkSimdReal farClamped = farthest.horizontalMin<4>();
    return nearClamped.isLessEqual( farClamped );
}

HK_INLINE hkBool32 hkVector4UtilInternal::intersectRay( const hkAabb& aabb, hkVector4Parameter rayOrg, hkVector4Parameter rayInvDir, hkSimdRealParameter maxFraction )
{
    hkVector4 dNearTemp;    dNearTemp.setSub( aabb.m_min, rayOrg );
    hkVector4 dFarTemp;     dFarTemp.setSub( aabb.m_max, rayOrg );

    dNearTemp.mul( rayInvDir );
    dFarTemp.mul( rayInvDir );

    hkVector4 dNear;        dNear.setMin( dNearTemp, dFarTemp );
    hkVector4 dFar;         dFar.setMax( dNearTemp, dFarTemp );

    hkVector4 nearest;  nearest.setXYZ_0( dNear );
    hkVector4 farthest; farthest.setXYZ_W( dFar, maxFraction );

    const hkSimdReal nearClamped = nearest.horizontalMax<4>();
    const hkSimdReal farClamped = farthest.horizontalMin<4>();

    return nearClamped.isLessEqual( farClamped );
}
#endif

HK_INLINE hkVector4Comparison hkVector4UtilInternal::intersectRayBundle( const hkAabb& aabb, const hkFourTransposedPoints& rayOrg, const hkFourTransposedPoints& rayInvDir, hkVector4Parameter maxFraction )
{
    hkVector4 zero; zero.setZero();

    hkFourTransposedPoints dNearTemp;
    dNearTemp.setSub( aabb.m_min, rayOrg );

    hkFourTransposedPoints dFarTemp;
    dFarTemp.setSub( aabb.m_max, rayOrg );

    dNearTemp.mul( rayInvDir );
    dFarTemp.mul( rayInvDir );

    hkFourTransposedPoints dNear, dFar;
    dNear.setMin( dNearTemp, dFarTemp );
    dFar.setMax( dNearTemp, dFarTemp );

    
    hkVector4 vNear;
    dNear.horizontalMax( vNear );
    vNear.setMax( vNear, zero );

    hkVector4 vFar;
    dFar.horizontalMin( vFar );
    vFar.setMin( maxFraction, vFar );

    return vNear.lessEqual( vFar );
}

//

#ifndef HK_VECTOR4UTIL_INTERNAL_computeRayInverseDirection
HK_INLINE void hkVector4UtilInternal::computeRayInverseDirection( hkVector4Parameter dir, hkVector4& invDirOut )
{
    hkVector4 invDir; invDir.setXYZ_0( dir );
    invDirOut.setReciprocal<HK_ACC_MID, HK_DIV_SET_MAX>( invDir );
}
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
