// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
TOPOLOGY_HDR
const EDGE TOPOLOGY_TYP::null_edge(0, 0);

//
TOPOLOGY_HDR
HK_INLINE unsigned  TOPOLOGY_TYP::ip1mod3(unsigned i)
{
    HK_ASSERT_NO_MSG(0x23be31ed, i<3);
#ifdef HK_ARCH_PPC
    // Variable shifts are slow on PowerPC consoles.
    // The ternary op should be pretty easy to optimize, however
    const unsigned mod3 = (i==2) ? 0 : i+1;
    return mod3;
#else
    return((0x09>>(i<<1))&3);
#endif
}

//
TOPOLOGY_HDR
HK_INLINE unsigned  TOPOLOGY_TYP::ip2mod3(unsigned i)
{
    HK_ASSERT_NO_MSG(0x23be31ed, i<3);
#ifdef HK_ARCH_PPC
    unsigned mod3 = (i==0) ? 2 : i-1;
    return mod3;
#else
    return((0x12>>(i<<1))&3);
#endif
}

//
TOPOLOGY_HDR
HKGP_FORCE_INLINE void      TOPOLOGY_TYP::bind(const Edge& edge) const
{
#if defined(HK_DEBUG_SLOW)
    if(!canBind(edge))
    {
        bool found=false;
        for(int i=2,j=0;j<3;i=j++)
        {
            if(edge.triangle()->vertex(i)==end() && edge.triangle()->vertex(j)==start())
            {
                hkLog_Info( s_hkgpTopologyLogOrigin, "Edge index should be {} instead of {}", i, edge.index() );
                found=true;break;
            }
        }
        if ( !found )
        {
            hkLog_Warning( s_hkgpTopologyLogOrigin, "Incorrect triangle bind" );
        }
    }
#endif
    HK_ASSERT(0x9801541,canBind(edge),"Incorrect edge bind");
    m_triangle->link(m_index)=edge.uid();
    if(edge.isValid()) edge.m_triangle->link(edge.m_index)=uid();
}
//
TOPOLOGY_HDR
HKGP_FORCE_INLINE void      TOPOLOGY_TYP::bindSides() const
{
    EDGE    n=next().link(),p=prev().link();
    if(p.isValid()) { EDGE t=n;n=p;p=t; }
    if(n.isValid())
    {
        n.bind(p);
        next().bind(null());
        prev().bind(null());
    }
}
//
TOPOLOGY_HDR
HKGP_FORCE_INLINE void      TOPOLOGY_TYP::unbind() const
{
    if(!isNaked())
    {
        EDGE l=link();
        l.m_triangle->link(l.m_index)=0;
    }
    m_triangle->link(m_index)=0;
}
//
TOPOLOGY_HDR
HKGP_FORCE_INLINE EDGE      TOPOLOGY_TYP::flip() const
{
    const Edge  lk=link();
    const Edge  ep=prev();
    const Edge  lp=lk.prev();
    start()=lp.start();
    lk.start()=ep.start();
    lk.bind(ep.link());
    bind(lp.link());
    ep.bind(lp);
    return(prev());
}

//
TOPOLOGY_HDR
template <typename FNC>
HKGP_FORCE_INLINE bool      TOPOLOGY_TYP::applyFan(FNC& fnc) const
{
    EDGE    base(self());
    EDGE    curr(base);
    do
    {
        if(fnc(curr)) curr=curr.turnCw(); else return false;
    } while(curr.isValid() && (curr!=base));
    if(!curr.isValid())
    {
        curr=base.turnCcw();
        while(curr.isValid())
        {
            if(fnc(curr)) curr=curr.turnCcw(); else return false;
        }
    }
    return true;
}

//
template <typename EDGE, typename FNC>
HKGP_FORCE_INLINE void      hkgpTopology::vertexRing( EDGE edge, const FNC& fnc )
{
    EDGE baseEdge = edge;
    bool closedRing = false;
    while ( edge.isBound() ) { edge = edge.nextCcw(); if ( edge == baseEdge ) { closedRing = true; break; } }
    if ( !closedRing ) baseEdge = EDGE::null();
    do { fnc( closedRing, edge.next() ); edge = edge.prevCw(); } while ( edge != baseEdge );
}

//
template <typename EDGE, typename FNC>
HKGP_FORCE_INLINE void      hkgpTopology::vertexRing( EDGE edge, FNC& fnc )
{
    EDGE baseEdge = edge;
    bool closedRing = false;
    while ( edge.isBound() ) { edge = edge.nextCcw(); if ( edge == baseEdge ) { closedRing = true; break; } }
    if ( !closedRing ) baseEdge = EDGE::null();
    do { fnc( closedRing, edge.next() ); edge = edge.prevCw(); } while ( edge != baseEdge );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
