// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Config/hkProductFeatures.h>

namespace   hkgpSimplexNoise
{
    // Deterministic isotropic noise in N dimensions.
    // - 'positions' must hold N elements.
    // - If FIRST_DER (Gradient) is true, 'der1' must be non-null and large enough to accomodate the N elements of the first derivative.
    // - If SECOND_DER (Laplacian) is true, 'der2' must be non-null and large enough to accomodate the (N*(1+N))/2 elements of the second derivative lower diagonal matrix (row major).
    template <int N, bool FIRST_DER, bool SECOND_DER>
    inline hkReal evaluate(_In_reads_(N) const hkReal* positions, _Out_writes_all_(N) hkReal* der1, _Out_writes_all_((N*(1 + N)) / 2) hkReal* der2);

    // fBm simplex noise.
    template <int N>
    inline hkReal   fBm(const hkVector4& x, int octaves, hkReal offset, hkReal persistence);
};

#include <Common/Internal/GeometryProcessing/SimplexNoise/hkgpSimplexNoise.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
